package ar.com.sdd.banconnector.debin.api.server.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.io.Serializable;
import java.math.BigDecimal;

@JsonIgnoreProperties(ignoreUnknown = true)
public class DebinInstruction implements Serializable {


    private String instructionId;
    private String cbuCredito;
    private String cbuDebito;
    private String aliasDebito;
    private String cuitDebito;
    private DebinConst.ConceptoEnum concepto;
    private String descripcion;
    private Integer tiempoExpiracion;
    private DebinConst.MonedaEnum moneda;
    private BigDecimal importe;
    private String instructionResultCode;
    private String instructionResultMessage;

    public String getInstructionId() {
        return instructionId;
    }

    public void setInstructionId(String instructionId) {
        this.instructionId = instructionId;
    }

    public String getCbuCredito() {
        return cbuCredito;
    }

    public void setCbuCredito(String cbuCredito) {
        this.cbuCredito = cbuCredito;
    }

    public String getCbuDebito() {
        return cbuDebito;
    }

    public void setCbuDebito(String cbuDebito) {
        this.cbuDebito = cbuDebito;
    }

    public String getAliasDebito() {
        return aliasDebito;
    }

    public void setAliasDebito(String aliasDebito) {
        this.aliasDebito = aliasDebito;
    }

    public String getCuitDebito() {
        return cuitDebito;
    }

    public void setCuitDebito(String cuitDebito) {
        this.cuitDebito = cuitDebito;
    }

    public DebinConst.ConceptoEnum getConcepto() {
        return concepto;
    }

    public void setConcepto(DebinConst.ConceptoEnum concepto) {
        this.concepto = concepto;
    }

    public String getDescripcion() {
        return descripcion;
    }

    public void setDescripcion(String descripcion) {
        this.descripcion = descripcion;
    }

    public Integer getTiempoExpiracion() {
        return tiempoExpiracion;
    }

    public void setTiempoExpiracion(Integer tiempoExpiracion) {
        this.tiempoExpiracion = tiempoExpiracion;
    }

    public DebinConst.MonedaEnum getMoneda() {
        return moneda;
    }

    public void setMoneda(DebinConst.MonedaEnum moneda) {
        this.moneda = moneda;
    }

    public BigDecimal getImporte() {
        return importe;
    }

    public void setImporte(BigDecimal importe) {
        this.importe = importe;
    }

    public String getInstructionResultCode() {
        return instructionResultCode;
    }

    public void setInstructionResultCode(String instructionResultCode) {
        this.instructionResultCode = instructionResultCode;
    }

    public String getInstructionResultMessage() {
        return instructionResultMessage;
    }

    public void setInstructionResultMessage(String instructionResultMessage) {
        this.instructionResultMessage = instructionResultMessage;
    }

    @Override
    public String toString() {
        return "DebinInstruction ["
                + ((instructionId != null) ? "instructionId=" + instructionId + ", " : "")
                + ((cbuCredito != null) ? "cbuCredito=" + cbuCredito + ", " : "")
                + ((cbuDebito != null) ? "cbuDebito=" + cbuDebito + ", " : "")
                + ((aliasDebito != null) ? "aliasDebito=" + aliasDebito + ", " : "")
                + ((cuitDebito != null) ? "cuitDebito=" + cuitDebito + ", " : "")
                + ((concepto != null) ? "concepto=" + concepto + ", " : "")
                + ((descripcion != null) ? "descripcion=" + descripcion + ", " : "")
                + ((tiempoExpiracion != null) ? "tiempoExpiracion=" + tiempoExpiracion + ", " : "")
                + ((moneda != null) ? "moneda=" + moneda + ", " : "")
                + ((importe != null) ? "importe=" + importe + ", " : "")
                + ((instructionResultCode != null) ? "instructionResultCode=" + instructionResultCode + ", " : "")
                + ((instructionResultMessage != null) ? "instructionResultMessage=" + instructionResultMessage : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        DebinInstruction that = (DebinInstruction) o;

        if (instructionId != null ? !instructionId.equals(that.instructionId) : that.instructionId != null) return false;
        if (cbuCredito != null ? !cbuCredito.equals(that.cbuCredito) : that.cbuCredito != null) return false;
        if (cbuDebito != null ? !cbuDebito.equals(that.cbuDebito) : that.cbuDebito != null) return false;
        if (aliasDebito != null ? !aliasDebito.equals(that.aliasDebito) : that.aliasDebito != null) return false;
        if (cuitDebito != null ? !cuitDebito.equals(that.cuitDebito) : that.cuitDebito != null) return false;
        if (concepto != that.concepto) return false;
        if (descripcion != null ? !descripcion.equals(that.descripcion) : that.descripcion != null) return false;
        if (tiempoExpiracion != null ? !tiempoExpiracion.equals(that.tiempoExpiracion) : that.tiempoExpiracion != null) return false;
        if (moneda != that.moneda) return false;
        if (importe != null ? !importe.equals(that.importe) : that.importe != null) return false;
        if (instructionResultCode != null ? !instructionResultCode.equals(that.instructionResultCode) : that.instructionResultCode != null) return false;
        return instructionResultMessage != null ? instructionResultMessage.equals(that.instructionResultMessage) : that.instructionResultMessage == null;
    }

    @Override
    public int hashCode() {
        int result = instructionId != null ? instructionId.hashCode() : 0;
        result = 31 * result + (cbuCredito != null ? cbuCredito.hashCode() : 0);
        result = 31 * result + (cbuDebito != null ? cbuDebito.hashCode() : 0);
        result = 31 * result + (aliasDebito != null ? aliasDebito.hashCode() : 0);
        result = 31 * result + (cuitDebito != null ? cuitDebito.hashCode() : 0);
        result = 31 * result + (concepto != null ? concepto.hashCode() : 0);
        result = 31 * result + (descripcion != null ? descripcion.hashCode() : 0);
        result = 31 * result + (tiempoExpiracion != null ? tiempoExpiracion.hashCode() : 0);
        result = 31 * result + (moneda != null ? moneda.hashCode() : 0);
        result = 31 * result + (importe != null ? importe.hashCode() : 0);
        result = 31 * result + (instructionResultCode != null ? instructionResultCode.hashCode() : 0);
        result = 31 * result + (instructionResultMessage != null ? instructionResultMessage.hashCode() : 0);
        return result;
    }
}

