package ar.com.sdd.banconnector.debin.api.server.rest;


import ar.com.sdd.commons.rest.log.ServerFileLogged;

import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Path("/account")
public class AccountApi {

    @Inject
    private AccountApiService service;

    @GET
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/debin-accounts/{accountCuit}")
    @Produces("application/json; charset=utf-8")
    public Response getDebinAccountsByCuit(@HeaderParam("Authorization") String authorization, @PathParam("aid") String aid, @PathParam("ownerId") String ownerId, @PathParam("accountCuit") String accountCuit, @Context SecurityContext securityContext) {
        return service.getDebinAccountsByCuit(authorization, aid, ownerId, accountCuit, securityContext);
    }

}
