/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.banconnector.debin.api.server.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public interface DebinConst {

    public static enum EstadoEnum {
        AEN("AEN"),
        ENV("ENV"),
        RECH("RECH"),
        EJE("EJE"),
        BNKRECH("BNKRECH"),
        DUERECH("DUERECH"),
        ERR("ERR"),
        SNP("SNP"),
        CLOPC("CLOPC"),
        CLOPA("CLOPA"),
        CLOPAR1("CLOPAR1");

        private String value;

        private EstadoEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum MonedaEnum {
        ARS("032", "Pesos", "ARS"),
        USD("840", "Dolares", "USD");

        private String code;
        private String desc;
        private String ebfCode;

        private MonedaEnum(String code, String desc, String ebfCode) {
            this.code = code;
            this.desc = desc;
            this.ebfCode = ebfCode;
        }

        @JsonCreator
        public static MonedaEnum forValue(String code) {
            if (code == null || code.equals("")) {
                return null;
            }
            for (MonedaEnum moneda : MonedaEnum.values()) {
                if (!moneda.code.equals(code)) continue;
                return moneda;
            }
            throw new RuntimeException("No existe la moneda para el codigo [" + code + "]");
        }

        public static MonedaEnum forValueEbf(String ebfCode) {
            if (ebfCode == null || ebfCode.equals("")) {
                return null;
            }
            for (MonedaEnum moneda : MonedaEnum.values()) {
                if (!moneda.ebfCode.equals(ebfCode)) continue;
                return moneda;
            }
            throw new RuntimeException("No existe la moneda para el codigo ebf [" + ebfCode + "]");
        }

        public String getCode() {
            return this.code;
        }

        public String getDesc() {
            return this.desc;
        }

        public String getEbfCode() {
            return this.ebfCode;
        }

        @JsonValue
        public String toValue() {
            return this.code;
        }
    }

    public static enum ConceptoEnum {
        ALQ("ALQ"),
        CUO("CUO"),
        EXP("EXP"),
        FAC("FAC"),
        PRE("PRE"),
        SEG("SEG"),
        HON("HON"),
        HAB("HAB"),
        VAR("VAR");

        private String value;

        private ConceptoEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

