package ar.com.sdd.banconnector.debin.api.server.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown = true)
public class DebinSet implements Serializable {

    private List<Debin> debines = new ArrayList<Debin>();

    public DebinSet() {

    }

    @JsonProperty("debines")
    public List<Debin> getDebines() {
        return debines;
    }

    public void setDebines(List<Debin> debines) {
        this.debines = debines;
    }

    @Override
    public String toString() {
        return "DebinSet ["
                + ((debines != null) ? "debines=" + Arrays.toString(debines.toArray()) : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        DebinSet debinSet = (DebinSet) o;

        return debines != null ? debines.equals(debinSet.debines) : debinSet.debines == null;
    }

    @Override
    public int hashCode() {
        return debines != null ? debines.hashCode() : 0;
    }
}

