package ar.com.sdd.banconnector.debin.api.server.rest;

import ar.com.sdd.banconnector.debin.api.server.model.DebinAccount;
import ar.com.sdd.commons.rest.log.ServerFileLogged;

import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Path("/account")
public class AccountApi {

    @Inject
    private AccountApiService service;

    @GET
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/debin-accounts")
    @Produces("application/json; charset=utf-8")
    public Response getDebinAccounts(@HeaderParam("Authorization") String authorization, @PathParam("aid") String aid, @PathParam("ownerId") String ownerId, @QueryParam("accountCuit") String accountCuit, @QueryParam("accountAlias") String accountAlias, @QueryParam("accountCbu") String accountCbu, @Context SecurityContext securityContext) {
        return service.getDebinAccounts(authorization, aid, ownerId, accountCuit, accountAlias, accountCbu, securityContext);
    }

    @POST
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/debin-accounts")
    @Consumes({"application/json"})
    @Produces("application/json; charset=utf-8")
    public Response postDebinAccount(@HeaderParam("Authorization") String authorization, @PathParam("aid") String aid, @PathParam("ownerId") String ownerId, DebinAccount debinAccount, @Context SecurityContext securityContext) {
        return service.postDebinAccount(authorization, aid, ownerId, debinAccount, securityContext);
    }

    @POST
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/payerCuit/{payerCuit}/debin-accounts")
    @Consumes({"application/json"})
    @Produces("application/json; charset=utf-8")
    public Response postDebinAccountOtherCuit(@HeaderParam("Authorization") String authorization, @PathParam("aid") String aid, @PathParam("ownerId") String ownerId, @PathParam("payerCuit") String payerCuit, DebinAccount debinAccount, @Context SecurityContext securityContext) {
        return service.postDebinAccountOtherCuit(authorization, aid, ownerId, payerCuit, debinAccount, securityContext);
    }

    @PUT
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/debin-accounts/{accountId}")
    @Consumes({"application/json"})
    @Produces("application/json; charset=utf-8")
    public Response putDebinAccount(@HeaderParam("Authorization") String authorization, @PathParam("aid") String aid, @PathParam("ownerId") String ownerId, @PathParam("accountId") String accountId, DebinAccount debinAccount, @Context SecurityContext securityContext) {
        return service.putDebinAccount(authorization, aid, ownerId, accountId, debinAccount, securityContext);
    }

    @GET
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/debin-accounts/{accountId}")
    @Produces("application/json; charset=utf-8")
    public Response getDebinAccount(@HeaderParam("Authorization") String authorization, @PathParam("aid") String aid, @PathParam("ownerId") String ownerId, @PathParam("accountId") String accountId, @Context SecurityContext securityContext) {
        return service.getDebinAccount(authorization, aid, ownerId, accountId, securityContext);
    }

    @DELETE
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/debin-accounts/{accountId}")
    @Produces("application/json; charset=utf-8")
    public Response deleteDebinAccount(@HeaderParam("Authorization") String authorization, @PathParam("aid") String aid, @PathParam("ownerId") String ownerId, @PathParam("accountId") String accountId, @Context SecurityContext securityContext) {
        return service.deleteDebinAccount(authorization, aid, ownerId, accountId, securityContext);
    }

    @GET
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/debin-accounts-search")
    @Produces("application/json; charset=utf-8")
    public Response getDebinAccountsSearch(@HeaderParam("Authorization") String authorization, @PathParam("aid") String aid, @PathParam("ownerId") String ownerId, @QueryParam("alias") String alias, @QueryParam("cbu") String cbu, @Context SecurityContext securityContext) {
        return service.getDebinAccountsSearch(authorization, aid, ownerId, alias, cbu, securityContext);
    }

}
