/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.banconnector.debin.api.server.rest;

import ar.com.sdd.banconnector.debin.api.server.model.DebinAccount;
import ar.com.sdd.banconnector.debin.api.server.rest.AccountApiService;
import ar.com.sdd.commons.rest.log.ServerFileLogged;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Path(value="/account")
public class AccountApi {
    @Inject
    private AccountApiService service;

    @GET
    @ServerFileLogged
    @Path(value="/aid/{aid}/owner/{ownerId}/debin-accounts")
    @Produces(value={"application/json; charset=utf-8"})
    public Response getDebinAccounts(@HeaderParam(value="Authorization") String authorization, @PathParam(value="aid") String aid, @PathParam(value="ownerId") String ownerId, @QueryParam(value="accountCuit") String accountCuit, @QueryParam(value="accountAlias") String accountAlias, @QueryParam(value="accountCbu") String accountCbu, @Context SecurityContext securityContext) {
        return this.service.getDebinAccounts(authorization, aid, ownerId, accountCuit, accountAlias, accountCbu, securityContext);
    }

    @POST
    @ServerFileLogged
    @Path(value="/aid/{aid}/owner/{ownerId}/debin-accounts")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json; charset=utf-8"})
    public Response postDebinAccount(@HeaderParam(value="Authorization") String authorization, @PathParam(value="aid") String aid, @PathParam(value="ownerId") String ownerId, DebinAccount debinAccount, @Context SecurityContext securityContext) {
        return this.service.postDebinAccount(authorization, aid, ownerId, debinAccount, securityContext);
    }

    @POST
    @ServerFileLogged
    @Path(value="/aid/{aid}/owner/{ownerId}/payerCuit/{payerCuit}/debin-accounts")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json; charset=utf-8"})
    public Response postDebinAccountOtherCuit(@HeaderParam(value="Authorization") String authorization, @PathParam(value="aid") String aid, @PathParam(value="ownerId") String ownerId, @PathParam(value="payerCuit") String payerCuit, DebinAccount debinAccount, @Context SecurityContext securityContext) {
        return this.service.postDebinAccountOtherCuit(authorization, aid, ownerId, payerCuit, debinAccount, securityContext);
    }

    @PUT
    @ServerFileLogged
    @Path(value="/aid/{aid}/owner/{ownerId}/debin-accounts/{accountId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json; charset=utf-8"})
    public Response putDebinAccount(@HeaderParam(value="Authorization") String authorization, @PathParam(value="aid") String aid, @PathParam(value="ownerId") String ownerId, @PathParam(value="accountId") String accountId, DebinAccount debinAccount, @Context SecurityContext securityContext) {
        return this.service.putDebinAccount(authorization, aid, ownerId, accountId, debinAccount, securityContext);
    }

    @GET
    @ServerFileLogged
    @Path(value="/aid/{aid}/owner/{ownerId}/debin-accounts/{accountId}")
    @Produces(value={"application/json; charset=utf-8"})
    public Response getDebinAccount(@HeaderParam(value="Authorization") String authorization, @PathParam(value="aid") String aid, @PathParam(value="ownerId") String ownerId, @PathParam(value="accountId") String accountId, @Context SecurityContext securityContext) {
        return this.service.getDebinAccount(authorization, aid, ownerId, accountId, securityContext);
    }

    @DELETE
    @ServerFileLogged
    @Path(value="/aid/{aid}/owner/{ownerId}/debin-accounts/{accountId}")
    @Produces(value={"application/json; charset=utf-8"})
    public Response deleteDebinAccount(@HeaderParam(value="Authorization") String authorization, @PathParam(value="aid") String aid, @PathParam(value="ownerId") String ownerId, @PathParam(value="accountId") String accountId, @Context SecurityContext securityContext) {
        return this.service.deleteDebinAccount(authorization, aid, ownerId, accountId, securityContext);
    }

    @GET
    @ServerFileLogged
    @Path(value="/aid/{aid}/owner/{ownerId}/debin-accounts-search")
    @Produces(value={"application/json; charset=utf-8"})
    public Response getDebinAccountsSearch(@HeaderParam(value="Authorization") String authorization, @PathParam(value="aid") String aid, @PathParam(value="ownerId") String ownerId, @QueryParam(value="alias") String alias, @QueryParam(value="cbu") String cbu, @Context SecurityContext securityContext) {
        return this.service.getDebinAccountsSearch(authorization, aid, ownerId, alias, cbu, securityContext);
    }
}

