package ar.com.sdd.banconnector.debin.api.server.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown = true)
public class DebinInstructionSet implements Serializable {

    private List<DebinInstruction> debinInstructions = new ArrayList<DebinInstruction>();

    public DebinInstructionSet() {

    }

    @JsonProperty("debinInstructions")
    public List<DebinInstruction> getDebinInstructions() {
        return debinInstructions;
    }

    public void setDebinInstructions(List<DebinInstruction> debinInstructions) {
        this.debinInstructions = debinInstructions;
    }

    @Override
    public String toString() {
        return "DebinInstructionSet ["
                + ((debinInstructions != null) ? "debinInstructions=" + Arrays.toString(debinInstructions.toArray()) : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        DebinInstructionSet that = (DebinInstructionSet) o;

        return debinInstructions != null ? debinInstructions.equals(that.debinInstructions) : that.debinInstructions == null;
    }

    @Override
    public int hashCode() {
        return debinInstructions != null ? debinInstructions.hashCode() : 0;
    }
}

