package ar.com.sdd.banconnector.debin.api.server.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown = true)
public class CapabilitySet implements Serializable {

    private List<Capability> capabilities = new ArrayList<>();

    public CapabilitySet() {

    }

    @JsonProperty("capabilities")
    public List<Capability> getCapabilities() {
        return capabilities;
    }

    public void setCapabilities(List<Capability> capabilities) {
        this.capabilities = capabilities;
    }

    @Override
    public String toString() {
        return "CapabilitySet ["
                + ((capabilities != null) ? "capabilities=" + Arrays.toString(capabilities.toArray()) : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        CapabilitySet that = (CapabilitySet) o;

        return capabilities != null ? capabilities.equals(that.capabilities) : that.capabilities == null;
    }

    @Override
    public int hashCode() {
        return capabilities != null ? capabilities.hashCode() : 0;
    }
}

