package ar.com.sdd.banconnector.debin.api.server.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@JsonIgnoreProperties(ignoreUnknown = true)
public class Debin implements Serializable {

    private String id;
    private String instructionId;
    private String vendedorCuit;
    private String vendedorCbu;
    private String compradorCuit;
    private String compradorCbu;
    private DebinConst.ConceptoEnum concepto;
    private String descripcion;
    private DebinConst.EstadoEnum estado;
    private String camaraComunicacionCodigo;
    private String camaraComunicacionDescripcion;
    private String camaraEstadoCodigo;
    private String camaraEstadoDescripcion;
    private Date fecha;
    private Date fechaExpiracion;
    private Integer tiempoExpiracion;
    private DebinConst.MonedaEnum moneda;
    private BigDecimal importe;
    private Date fechaCredito;
    private BigDecimal importeCredito;
    private String prestacion;
    private Integer evaluacionPuntaje;
    private String evaluacionReglas;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getInstructionId() {
        return instructionId;
    }

    public void setInstructionId(String instructionId) {
        this.instructionId = instructionId;
    }

    public String getVendedorCuit() {
        return vendedorCuit;
    }

    public void setVendedorCuit(String vendedorCuit) {
        this.vendedorCuit = vendedorCuit;
    }

    public String getVendedorCbu() {
        return vendedorCbu;
    }

    public void setVendedorCbu(String vendedorCbu) {
        this.vendedorCbu = vendedorCbu;
    }

    public String getCompradorCuit() {
        return compradorCuit;
    }

    public void setCompradorCuit(String compradorCuit) {
        this.compradorCuit = compradorCuit;
    }

    public String getCompradorCbu() {
        return compradorCbu;
    }

    public void setCompradorCbu(String compradorCbu) {
        this.compradorCbu = compradorCbu;
    }

    public DebinConst.ConceptoEnum getConcepto() {
        return concepto;
    }

    public void setConcepto(DebinConst.ConceptoEnum concepto) {
        this.concepto = concepto;
    }

    public String getDescripcion() {
        return descripcion;
    }

    public void setDescripcion(String descripcion) {
        this.descripcion = descripcion;
    }

    public DebinConst.EstadoEnum getEstado() {
        return estado;
    }

    public void setEstado(DebinConst.EstadoEnum estado) {
        this.estado = estado;
    }

    public String getCamaraComunicacionCodigo() {
        return camaraComunicacionCodigo;
    }

    public void setCamaraComunicacionCodigo(String camaraComunicacionCodigo) {
        this.camaraComunicacionCodigo = camaraComunicacionCodigo;
    }

    public String getCamaraComunicacionDescripcion() {
        return camaraComunicacionDescripcion;
    }

    public void setCamaraComunicacionDescripcion(String camaraComunicacionDescripcion) {
        this.camaraComunicacionDescripcion = camaraComunicacionDescripcion;
    }

    public String getCamaraEstadoCodigo() {
        return camaraEstadoCodigo;
    }

    public void setCamaraEstadoCodigo(String camaraEstadoCodigo) {
        this.camaraEstadoCodigo = camaraEstadoCodigo;
    }

    public String getCamaraEstadoDescripcion() {
        return camaraEstadoDescripcion;
    }

    public void setCamaraEstadoDescripcion(String camaraEstadoDescripcion) {
        this.camaraEstadoDescripcion = camaraEstadoDescripcion;
    }

    public Date getFecha() {
        return fecha;
    }

    public void setFecha(Date fecha) {
        this.fecha = fecha;
    }

    public Date getFechaExpiracion() {
        return fechaExpiracion;
    }

    public void setFechaExpiracion(Date fechaExpiracion) {
        this.fechaExpiracion = fechaExpiracion;
    }

    public Integer getTiempoExpiracion() {
        return tiempoExpiracion;
    }

    public void setTiempoExpiracion(Integer tiempoExpiracion) {
        this.tiempoExpiracion = tiempoExpiracion;
    }

    public DebinConst.MonedaEnum getMoneda() {
        return moneda;
    }

    public void setMoneda(DebinConst.MonedaEnum moneda) {
        this.moneda = moneda;
    }

    public BigDecimal getImporte() {
        return importe;
    }

    public void setImporte(BigDecimal importe) {
        this.importe = importe;
    }

    public Date getFechaCredito() {
        return fechaCredito;
    }

    public void setFechaCredito(Date fechaCredito) {
        this.fechaCredito = fechaCredito;
    }

    public BigDecimal getImporteCredito() {
        return importeCredito;
    }

    public void setImporteCredito(BigDecimal importeCredito) {
        this.importeCredito = importeCredito;
    }

    public String getPrestacion() {
        return prestacion;
    }

    public void setPrestacion(String prestacion) {
        this.prestacion = prestacion;
    }

    public Integer getEvaluacionPuntaje() {
        return evaluacionPuntaje;
    }

    public void setEvaluacionPuntaje(Integer evaluacionPuntaje) {
        this.evaluacionPuntaje = evaluacionPuntaje;
    }

    public String getEvaluacionReglas() {
        return evaluacionReglas;
    }

    public void setEvaluacionReglas(String evaluacionReglas) {
        this.evaluacionReglas = evaluacionReglas;
    }

    @Override
    public String toString() {
        return "Debin ["
                + ((id != null) ? "id=" + id + ", " : "")
                + ((instructionId != null) ? "instructionId=" + instructionId + ", " : "")
                + ((vendedorCuit != null) ? "vendedorCuit=" + vendedorCuit + ", " : "")
                + ((vendedorCbu != null) ? "vendedorCbu=" + vendedorCbu + ", " : "")
                + ((compradorCuit != null) ? "compradorCuit=" + compradorCuit + ", " : "")
                + ((compradorCbu != null) ? "compradorCbu=" + compradorCbu + ", " : "")
                + ((concepto != null) ? "concepto=" + concepto + ", " : "")
                + ((descripcion != null) ? "descripcion=" + descripcion + ", " : "")
                + ((estado != null) ? "estado=" + estado + ", " : "")
                + ((camaraComunicacionCodigo != null) ? "camaraComunicacionCodigo=" + camaraComunicacionCodigo + ", " : "")
                + ((camaraComunicacionDescripcion != null) ? "camaraComunicacionDescripcion=" + camaraComunicacionDescripcion + ", " : "")
                + ((camaraEstadoCodigo != null) ? "camaraEstadoCodigo=" + camaraEstadoCodigo + ", " : "")
                + ((camaraEstadoDescripcion != null) ? "camaraEstadoDescripcion=" + camaraEstadoDescripcion + ", " : "")
                + ((fecha != null) ? "fecha=" + fecha + ", " : "")
                + ((fechaExpiracion != null) ? "fechaExpiracion=" + fechaExpiracion + ", " : "")
                + ((tiempoExpiracion != null) ? "tiempoExpiracion=" + tiempoExpiracion + ", " : "")
                + ((moneda != null) ? "moneda=" + moneda + ", " : "")
                + ((importe != null) ? "importe=" + importe + ", " : "")
                + ((fechaCredito != null) ? "fechaCredito=" + fechaCredito + ", " : "")
                + ((importeCredito != null) ? "importeCredito=" + importeCredito + ", " : "")
                + ((prestacion != null) ? "prestacion=" + prestacion + ", " : "")
                + ((evaluacionPuntaje != null) ? "evaluacionPuntaje=" + evaluacionPuntaje + ", " : "")
                + ((evaluacionReglas != null) ? "evaluacionReglas=" + evaluacionReglas : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Debin debin = (Debin) o;

        if (id != null ? !id.equals(debin.id) : debin.id != null) return false;
        if (instructionId != null ? !instructionId.equals(debin.instructionId) : debin.instructionId != null) return false;
        if (vendedorCuit != null ? !vendedorCuit.equals(debin.vendedorCuit) : debin.vendedorCuit != null) return false;
        if (vendedorCbu != null ? !vendedorCbu.equals(debin.vendedorCbu) : debin.vendedorCbu != null) return false;
        if (compradorCuit != null ? !compradorCuit.equals(debin.compradorCuit) : debin.compradorCuit != null) return false;
        if (compradorCbu != null ? !compradorCbu.equals(debin.compradorCbu) : debin.compradorCbu != null) return false;
        if (concepto != debin.concepto) return false;
        if (descripcion != null ? !descripcion.equals(debin.descripcion) : debin.descripcion != null) return false;
        if (estado != debin.estado) return false;
        if (camaraComunicacionCodigo != null ? !camaraComunicacionCodigo.equals(debin.camaraComunicacionCodigo) : debin.camaraComunicacionCodigo != null) return false;
        if (camaraComunicacionDescripcion != null ? !camaraComunicacionDescripcion.equals(debin.camaraComunicacionDescripcion) : debin.camaraComunicacionDescripcion != null) return false;
        if (camaraEstadoCodigo != null ? !camaraEstadoCodigo.equals(debin.camaraEstadoCodigo) : debin.camaraEstadoCodigo != null) return false;
        if (camaraEstadoDescripcion != null ? !camaraEstadoDescripcion.equals(debin.camaraEstadoDescripcion) : debin.camaraEstadoDescripcion != null) return false;
        if (fecha != null ? !fecha.equals(debin.fecha) : debin.fecha != null) return false;
        if (fechaExpiracion != null ? !fechaExpiracion.equals(debin.fechaExpiracion) : debin.fechaExpiracion != null) return false;
        if (tiempoExpiracion != null ? !tiempoExpiracion.equals(debin.tiempoExpiracion) : debin.tiempoExpiracion != null) return false;
        if (moneda != debin.moneda) return false;
        if (importe != null ? !importe.equals(debin.importe) : debin.importe != null) return false;
        if (fechaCredito != null ? !fechaCredito.equals(debin.fechaCredito) : debin.fechaCredito != null) return false;
        if (importeCredito != null ? !importeCredito.equals(debin.importeCredito) : debin.importeCredito != null) return false;
        if (prestacion != null ? !prestacion.equals(debin.prestacion) : debin.prestacion != null) return false;
        if (evaluacionPuntaje != null ? !evaluacionPuntaje.equals(debin.evaluacionPuntaje) : debin.evaluacionPuntaje != null) return false;
        return evaluacionReglas != null ? evaluacionReglas.equals(debin.evaluacionReglas) : debin.evaluacionReglas == null;
    }

    @Override
    public int hashCode() {
        int result = id != null ? id.hashCode() : 0;
        result = 31 * result + (instructionId != null ? instructionId.hashCode() : 0);
        result = 31 * result + (vendedorCuit != null ? vendedorCuit.hashCode() : 0);
        result = 31 * result + (vendedorCbu != null ? vendedorCbu.hashCode() : 0);
        result = 31 * result + (compradorCuit != null ? compradorCuit.hashCode() : 0);
        result = 31 * result + (compradorCbu != null ? compradorCbu.hashCode() : 0);
        result = 31 * result + (concepto != null ? concepto.hashCode() : 0);
        result = 31 * result + (descripcion != null ? descripcion.hashCode() : 0);
        result = 31 * result + (estado != null ? estado.hashCode() : 0);
        result = 31 * result + (camaraComunicacionCodigo != null ? camaraComunicacionCodigo.hashCode() : 0);
        result = 31 * result + (camaraComunicacionDescripcion != null ? camaraComunicacionDescripcion.hashCode() : 0);
        result = 31 * result + (camaraEstadoCodigo != null ? camaraEstadoCodigo.hashCode() : 0);
        result = 31 * result + (camaraEstadoDescripcion != null ? camaraEstadoDescripcion.hashCode() : 0);
        result = 31 * result + (fecha != null ? fecha.hashCode() : 0);
        result = 31 * result + (fechaExpiracion != null ? fechaExpiracion.hashCode() : 0);
        result = 31 * result + (tiempoExpiracion != null ? tiempoExpiracion.hashCode() : 0);
        result = 31 * result + (moneda != null ? moneda.hashCode() : 0);
        result = 31 * result + (importe != null ? importe.hashCode() : 0);
        result = 31 * result + (fechaCredito != null ? fechaCredito.hashCode() : 0);
        result = 31 * result + (importeCredito != null ? importeCredito.hashCode() : 0);
        result = 31 * result + (prestacion != null ? prestacion.hashCode() : 0);
        result = 31 * result + (evaluacionPuntaje != null ? evaluacionPuntaje.hashCode() : 0);
        result = 31 * result + (evaluacionReglas != null ? evaluacionReglas.hashCode() : 0);
        return result;
    }
}

