package ar.com.sdd.banconnector.debin.api.server.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public interface DebinConst {

    //Hay un enum IGUAL -o caso- en el proyecto sdd.debin
    enum ConceptoEnum {
        ALQ("ALQ"),
        CUO("CUO"),
        EXP("EXP"),
        FAC("FAC"),
        PRE("PRE"),
        SEG("SEG"),
        HON("HON"),
        HAB("HAB"),
        VAR("VAR"),
        OIN("OIN"),
        OIH("OIH"),
        BRH("BRH"),
        BRN("BRN"),
        SON("SON"),
        APC("APC"),
        ROP("ROP"),
        SIS("SIS"),
        ESE("ESE"),
        //Propios de QR
        PCT("PCT"),
        CCT("CCT"),
        DCT("DCT"),
        ECT("ECT");

        private String value;

        ConceptoEnum(String value) {
            this.value = value;
        }

        @Override
        @JsonValue
        public String toString() {
            return String.valueOf(value);
        }
    }

    enum MonedaEnum {
        ARS("032", "Pesos", "ARS"),
        USD("840", "Dolares", "USD"),;

        private String code;
        private String desc;
        private String ebfCode;

        MonedaEnum(String code, String desc, String ebfCode) {
            this.code = code;
            this.desc = desc;
            this.ebfCode = ebfCode;
        }

        @JsonCreator
        public static MonedaEnum forValue(String code) {
            if (code == null || code.equals("")) {
                return null;
            }
            for (MonedaEnum moneda : MonedaEnum.values()) {
                if (moneda.code.equals(code)) {
                    return moneda;
                }
            }
            throw new RuntimeException("No existe la moneda para el codigo [" + code + "]");
        }

        public static MonedaEnum forValueEbf(String ebfCode) {
            if (ebfCode == null || ebfCode.equals("")) {
                return null;
            }
            for (MonedaEnum moneda : MonedaEnum.values()) {
                if (moneda.ebfCode.equals(ebfCode)) {
                    return moneda;
                }
            }
            throw new RuntimeException("No existe la moneda para el codigo ebf [" + ebfCode + "]");
        }

        public String getCode() {
            return code;
        }

        public String getDesc() {
            return desc;
        }

        public String getEbfCode() {
            return ebfCode;
        }

        @JsonValue
        public String toValue() {
            return this.code;
        }
    }


    enum EstadoEnum {

        ANU("ANU"),
        AEN("AEN"),
        ENV("ENV"),
        RECH("RECH"),
        EJE("EJE"),
        ERPEJE("ERPEJE"),
        ERPEJE1("ERPEJE1"),
        ERPRECH("ERPRECH"),
        BNKRECH("BNKRECH"),
        DUERECH("DUERECH"),
        ERR("ERR"),
        SNP("SNP"),
        CLOPC("CLOPC"),
        CLOPA("CLOPA"),
        CLOPAR1("CLOPAR1"),
        BNKERR("BNKERR"),
        ERPPGENV("ERPPGENV"),
        DEL("DEL"),;

        private String value;

        EstadoEnum(String value) {
            this.value = value;
        }

        @Override
        @JsonValue
        public String toString() {
            return String.valueOf(value);
        }

    }

    enum DebinAccountStatusEnum {

        NEW("NEW"),
        APG("APG"),
        ANU("ANU"),
        DEL("DEL"),;
        private String value;

        DebinAccountStatusEnum(String value) {
            this.value = value;
        }

        @Override
        @JsonValue
        public String toString() {
            return String.valueOf(value);
        }

    }

}
