package ar.com.sdd.banconnector.api.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.Arrays;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Image implements Serializable {

    private String mimeType = null;
    private byte[] data = null;

    public Image() {

    }

    /**
     * MIME type
     **/

    @JsonProperty("mimeType")
    @NotNull
    @Size(max = 50)
    public String getMimeType() {
        return mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    /**
     * Bytes de la imágen en Base64
     **/

    @JsonProperty("data")
    @NotNull
    @Size(max = 8192)
    public byte[] getData() {
        return data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    @Override
    public String toString() {
        return "Image ["
                + ((mimeType != null) ? "mimeType=" + mimeType + ", " : "")
                + ((data != null) ? "data=" + Arrays.toString(data) : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Image image = (Image) o;

        if (mimeType != null ? !mimeType.equals(image.mimeType) : image.mimeType != null) return false;
        return Arrays.equals(data, image.data);
    }

    @Override
    public int hashCode() {
        int result = mimeType != null ? mimeType.hashCode() : 0;
        result = 31 * result + Arrays.hashCode(data);
        return result;
    }
}

