package ar.com.sdd.banconnector.api.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;

import java.io.Serializable;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TokenOAuth2Error implements Serializable {


    /**
     * Código de error
     */
    public enum ErrorEnum {
        INVALID_REQUEST("invalid_request"),

        INVALID_CLIENT("invalid_client"),

        INVALID_GRANT("invalid_grant"),

        UNAUTHORIZED_CLIENT("unauthorized_client"),

        UNSUPPORTED_GRANT_TYPE("unsupported_grant_type");
        private String value;

        ErrorEnum(String value) {
            this.value = value;
        }

        @Override
        @JsonValue
        public String toString() {
            return String.valueOf(value);
        }
    }

    private ErrorEnum error = null;
    private String errorDescription = null;

    public TokenOAuth2Error() {

    }

    /**
     * Código de error
     **/


    @JsonProperty("error")
    public ErrorEnum getError() {
        return error;
    }

    public void setError(ErrorEnum error) {
        this.error = error;
    }

    /**
     * Descripción opcional del error
     **/


    @JsonProperty("error_description")
    public String getErrorDescription() {
        return errorDescription;
    }

    public void setErrorDescription(String errorDescription) {
        this.errorDescription = errorDescription;
    }

    @Override
    public String toString() {
        return "TokenOAuth2Error ["
                + ((error != null) ? "error=" + error + ", " : "")
                + ((errorDescription != null) ? "errorDescription=" + errorDescription : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        TokenOAuth2Error that = (TokenOAuth2Error) o;

        if (error != that.error) return false;
        return errorDescription != null ? errorDescription.equals(that.errorDescription) : that.errorDescription == null;
    }

    @Override
    public int hashCode() {
        int result = error != null ? error.hashCode() : 0;
        result = 31 * result + (errorDescription != null ? errorDescription.hashCode() : 0);
        return result;
    }
}

