package ar.com.sdd.banconnector.api.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class BanconnectorUtil {

    /**
     * El metodo retorna la current-time en milisegundos (en base 36).
     * @return
     */
    public static String getCacheSafeValue() {
        long ts = System.currentTimeMillis();
        return Long.toString(ts, Character.MAX_RADIX);
    }

    public static String serializeToJsonString(Object object) throws JsonProcessingException {
        return serializeToJsonString(object, false);
    }

    public static String serializeToJsonString(Object object, boolean prettyPrint) throws JsonProcessingException {
        ObjectMapper mapper = JacksonConfig.getObjectMapper();
        if (prettyPrint) {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(object);
        } else {
            return mapper.writeValueAsString(object);
        }
    }

    public static void serializeToJsonOutputStream(Object object, OutputStream outputStream) throws IOException {
        serializeToJsonOutputStream(object, outputStream, false);
    }

    public static void serializeToJsonOutputStream(Object object, OutputStream outputStream, boolean prettyPrint) throws IOException {
        ObjectMapper mapper = JacksonConfig.getObjectMapper();
        if (prettyPrint) {
            mapper.writerWithDefaultPrettyPrinter().writeValue(outputStream, object);
        } else {
            mapper.writeValue(outputStream, object);
        }
    }

    public static <T> T deserializeFromJsonString(String json, Class<T> type) throws IOException {
        ObjectMapper mapper = JacksonConfig.getObjectMapper();
        return mapper.readValue(json, type);
    }

    public static <T> T deserializeFromJsonInputStream(InputStream inputStream, Class<T> type) throws IOException {
        ObjectMapper mapper = JacksonConfig.getObjectMapper();
        return mapper.readValue(inputStream, type);
    }

}
