package ar.com.sdd.banconnector.api;


import ar.com.sdd.banconnector.api.model.OAuth2Credential;
import ar.com.sdd.commons.rest.log.ServerFileLogged;

import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Path("/auth")
public class AuthApi {

    @Inject
    AuthApiService service;

    @POST
    @ServerFileLogged
    @Path("/owner/{ownerCuit}/token.oauth2")
    @Consumes({"application/json"})
    @Produces("application/json; charset=utf-8")
    public Response postTokenOauth2(@PathParam("ownerCuit") String ownerCuit, OAuth2Credential oauthCredentials, @Context SecurityContext securityContext) {
        return service.postTokenOauth2(ownerCuit, oauthCredentials, securityContext);
    }
}
