package ar.com.sdd.banconnector.api.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class CollectionSet implements Serializable {

    private Long trackingNumber = null;
    private String ownerCuit = null;
    private String agreementCode = null;

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date processDate = null;
    private BanconnectorEnum.PublicationModeEnum publicationMode = null;
    private List<CollectionItem> collectionItems = new ArrayList<CollectionItem>();

    public CollectionSet() {

    }

    /**
     * Número de seguimiento
     **/


    @JsonProperty("trackingNumber")
    public Long getTrackingNumber() {
        return trackingNumber;
    }

    public void setTrackingNumber(Long trackingNumber) {
        this.trackingNumber = trackingNumber;
    }

    /**
     * CUIT del propietario de las cuentas (sin guiones ni espacios)
     **/


    @JsonProperty("ownerCuit")
    @Size(max = 11)
    public String getOwnerCuit() {
        return ownerCuit;
    }

    public void setOwnerCuit(String ownerCuit) {
        this.ownerCuit = ownerCuit;
    }

    /**
     * Código de acuerdo
     **/


    @JsonProperty("agreementCode")
    @Size(max = 50)
    public String getAgreementCode() {
        return agreementCode;
    }

    public void setAgreementCode(String agreementCode) {
        this.agreementCode = agreementCode;
    }

    /**
     * Fecha de la publicación
     **/


    @JsonProperty("processDate")
    public Date getProcessDate() {
        return processDate;
    }

    public void setProcessDate(Date processDate) {
        this.processDate = processDate;
    }

    /**
     * Indica si el envío debe ser considerado como un FULL-REFRESH, o INCREMENTAL
     **/


    @JsonProperty("publicationMode")
    public BanconnectorEnum.PublicationModeEnum getPublicationMode() {
        return publicationMode;
    }

    public void setPublicationMode(BanconnectorEnum.PublicationModeEnum publicationMode) {
        this.publicationMode = publicationMode;
    }

    /**
     * Lista de documentos a publicar
     **/


    @JsonProperty("collectionItems")
    public List<CollectionItem> getCollectionItems() {
        return collectionItems;
    }

    public void setCollectionItems(List<CollectionItem> collectionItems) {
        this.collectionItems = collectionItems;
    }

    @Override
    public String toString() {
        return "CollectionSet ["
                + ((trackingNumber != null) ? "trackingNumber=" + trackingNumber + ", " : "")
                + ((ownerCuit != null) ? "ownerCuit=" + ownerCuit + ", " : "")
                + ((agreementCode != null) ? "agreementCode=" + agreementCode + ", " : "")
                + ((processDate != null) ? "processDate=" + processDate + ", " : "")
                + ((publicationMode != null) ? "publicationMode=" + publicationMode + ", " : "")
                + ((collectionItems != null) ? "collectionItems=" + Arrays.toString(collectionItems.toArray()) : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        CollectionSet that = (CollectionSet) o;

        if (trackingNumber != null ? !trackingNumber.equals(that.trackingNumber) : that.trackingNumber != null) return false;
        if (ownerCuit != null ? !ownerCuit.equals(that.ownerCuit) : that.ownerCuit != null) return false;
        if (agreementCode != null ? !agreementCode.equals(that.agreementCode) : that.agreementCode != null) return false;
        if (processDate != null ? !processDate.equals(that.processDate) : that.processDate != null) return false;
        if (publicationMode != that.publicationMode) return false;
        return collectionItems != null ? collectionItems.equals(that.collectionItems) : that.collectionItems == null;
    }

    @Override
    public int hashCode() {
        int result = trackingNumber != null ? trackingNumber.hashCode() : 0;
        result = 31 * result + (ownerCuit != null ? ownerCuit.hashCode() : 0);
        result = 31 * result + (agreementCode != null ? agreementCode.hashCode() : 0);
        result = 31 * result + (processDate != null ? processDate.hashCode() : 0);
        result = 31 * result + (publicationMode != null ? publicationMode.hashCode() : 0);
        result = 31 * result + (collectionItems != null ? collectionItems.hashCode() : 0);
        return result;
    }
}

