package ar.com.sdd.banconnector.api.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PaymentInstrument implements Serializable {

    /**
     * Formas de pago
     */
    public enum InstructionCodeEnum {
        EFEC("EFEC"),

        CHEQ("CHEQ"),

        TRAN("TRAN"),

        CPD("CPD");
        private String value;

        InstructionCodeEnum(String value) {
            this.value = value;
        }

        @Override
        @JsonValue
        public String toString() {
            return String.valueOf(value);
        }
    }

    /**
     * Estado del instrumento * PENDING: el instrumento todavia no esta en un estado final. No es necesario precisar los estados intermedios, incluso si hay un redepósito. * REJECTED: el instrumento fue rechazado y va a permanecer en ese estado final. * PAID: el instrumento fue pagado. * REVERSED: el instrumento sufrió una reversa. * RESCUED: el instrumento fue rescatado.
     */
    public enum InstrumentStatusEnum {
        PENDING("PENDING"),

        REJECTED("REJECTED"),

        PAID("PAID"),

        REVERSED("REVERSED"),

        RESCUED("RESCUED");

        private String value;

        InstrumentStatusEnum(String value) {
            this.value = value;
        }

        @Override
        @JsonValue
        public String toString() {
            return String.valueOf(value);
        }
    }

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date depositSlipIssueDate = null;
    private BigDecimal depositSlipTotalAmount = null;
    private String depositSlipReference = null;
    private String legalReference = null;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date issueDate = null;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date dueDate = null;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date creditDate = null;
    private InstructionCodeEnum instructionCode = null;
    private String instructionNumber = null;
    private String bankInstructionCode = null;
    private String issuerBankCode = null;
    private String issuerBranch = null;
    private String collectorBankCode = null;
    private String collectorBranch = null;
    private String comments = null;
    private BigDecimal penaltyAmount = null;
    private BigDecimal discountAmount = null;
    private InstrumentStatusEnum status = null;
    private String bankStatus = null;
    private String rejectionReason = null;
    private String currencyCode = null;
    private BigDecimal amount = null;

    public PaymentInstrument() {

    }

    /**
     * Fecha de emisión de la boleta (si el instrumento se encuentra en una)
     **/


    @JsonProperty("depositSlipIssueDate")
    public Date getDepositSlipIssueDate() {
        return depositSlipIssueDate;
    }

    public void setDepositSlipIssueDate(Date depositSlipIssueDate) {
        this.depositSlipIssueDate = depositSlipIssueDate;
    }

    /**
     * [15.2]Monto total de la boleta (si el instrumento se encuentra en una)
     **/


    @JsonProperty("depositSlipTotalAmount")
    public BigDecimal getDepositSlipTotalAmount() {
        return depositSlipTotalAmount;
    }

    public void setDepositSlipTotalAmount(BigDecimal depositSlipTotalAmount) {
        this.depositSlipTotalAmount = depositSlipTotalAmount;
    }

    /**
     * Indentificación de la boleta (si el instrumento se encuentra en una)
     **/


    @JsonProperty("depositSlipReference")
    @Size(max = 255)
    public String getDepositSlipReference() {
        return depositSlipReference;
    }

    public void setDepositSlipReference(String depositSlipReference) {
        this.depositSlipReference = depositSlipReference;
    }

    /**
     * Identificación del instrumento
     **/


    @JsonProperty("legalReference")
    @NotNull
    @Size(max = 255)
    public String getLegalReference() {
        return legalReference;
    }

    public void setLegalReference(String legalReference) {
        this.legalReference = legalReference;
    }

    /**
     * Fecha de emisión
     **/


    @JsonProperty("issueDate")
    @NotNull
    public Date getIssueDate() {
        return issueDate;
    }

    public void setIssueDate(Date issueDate) {
        this.issueDate = issueDate;
    }

    /**
     * Fecha de vencimiento
     **/


    @JsonProperty("dueDate")
    public Date getDueDate() {
        return dueDate;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    /**
     * Fecha de acreditación
     **/


    @JsonProperty("creditDate")
    public Date getCreditDate() {
        return creditDate;
    }

    public void setCreditDate(Date creditDate) {
        this.creditDate = creditDate;
    }

    /**
     * Formas de pago
     **/


    @JsonProperty("instructionCode")
    @NotNull
    public InstructionCodeEnum getInstructionCode() {
        return instructionCode;
    }

    public void setInstructionCode(InstructionCodeEnum instructionCode) {
        this.instructionCode = instructionCode;
    }


    @JsonProperty("instructionNumber")
    @Size(max = 255)
    public String getInstructionNumber() {
        return instructionNumber;
    }

    public void setInstructionNumber(String instructionNumber) {
        this.instructionNumber = instructionNumber;
    }

    /**
     * Código interno del banco de la forma de pago
     **/


    @JsonProperty("bankInstructionCode")
    @Size(max = 50)
    public String getBankInstructionCode() {
        return bankInstructionCode;
    }

    public void setBankInstructionCode(String bankInstructionCode) {
        this.bankInstructionCode = bankInstructionCode;
    }

    /**
     * Código de banco emisor
     **/


    @JsonProperty("issuerBankCode")
    @Size(max = 50)
    public String getIssuerBankCode() {
        return issuerBankCode;
    }

    public void setIssuerBankCode(String issuerBankCode) {
        this.issuerBankCode = issuerBankCode;
    }

    /**
     * Sucursal de banco emisor
     **/


    @JsonProperty("issuerBranch")
    @Size(max = 50)
    public String getIssuerBranch() {
        return issuerBranch;
    }

    public void setIssuerBranch(String issuerBranch) {
        this.issuerBranch = issuerBranch;
    }

    /**
     * Código de banco depósito
     **/


    @JsonProperty("collectorBankCode")
    @Size(max = 50)
    public String getCollectorBankCode() {
        return collectorBankCode;
    }

    public void setCollectorBankCode(String collectorBankCode) {
        this.collectorBankCode = collectorBankCode;
    }

    /**
     * Sucursal de banco depósito
     **/


    @JsonProperty("collectorBranch")
    @Size(max = 50)
    public String getCollectorBranch() {
        return collectorBranch;
    }

    public void setCollectorBranch(String collectorBranch) {
        this.collectorBranch = collectorBranch;
    }

    /**
     * Texto libre
     **/


    @JsonProperty("comments")
    @Size(max = 200)
    public String getComments() {
        return comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    /**
     * [15.2]Monto aplicado por punitorios
     **/


    @JsonProperty("penaltyAmount")
    public BigDecimal getPenaltyAmount() {
        return penaltyAmount;
    }

    public void setPenaltyAmount(BigDecimal penaltyAmount) {
        this.penaltyAmount = penaltyAmount;
    }

    /**
     * [15.2]Monto aplicado por pronto pago
     **/


    @JsonProperty("discountAmount")
    public BigDecimal getDiscountAmount() {
        return discountAmount;
    }

    public void setDiscountAmount(BigDecimal discountAmount) {
        this.discountAmount = discountAmount;
    }

    /**
     * Estado del instrumento * PENDING: el instrumento todavia no esta en un estado final. No es necesario precisar los estados intermedios, incluso si hay un redepósito. * REJECTED: el instrumento fue rechazado y va a permanecer en ese estado final. * PAID: el instrumento fue pagado. * REVERSED: el instrumento sufrió una reversa.
     **/


    @JsonProperty("status")
    public InstrumentStatusEnum getStatus() {
        return status;
    }

    public void setStatus(InstrumentStatusEnum status) {
        this.status = status;
    }

    /**
     * Estado del instrumento en el código del banco (cheques)
     **/


    @JsonProperty("bankStatus")
    @Size(max = 50)
    public String getBankStatus() {
        return bankStatus;
    }

    public void setBankStatus(String bankStatus) {
        this.bankStatus = bankStatus;
    }

    /**
     * Motivo de rechazo
     **/


    @JsonProperty("rejectionReason")
    @Size(max = 50)
    public String getRejectionReason() {
        return rejectionReason;
    }

    public void setRejectionReason(String rejectionReason) {
        this.rejectionReason = rejectionReason;
    }

    /**
     * Código de moneda ISO 4217
     **/


    @JsonProperty("currencyCode")
    @Size(max = 3)
    public String getCurrencyCode() {
        return currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    /**
     * [15.2]Monto aplicado
     **/


    @JsonProperty("amount")
    @NotNull
    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    @Override
    public String toString() {
        return "PaymentInstrument ["
                + ((depositSlipIssueDate != null) ? "depositSlipIssueDate=" + depositSlipIssueDate + ", " : "")
                + ((depositSlipTotalAmount != null) ? "depositSlipTotalAmount=" + depositSlipTotalAmount + ", " : "")
                + ((depositSlipReference != null) ? "depositSlipReference=" + depositSlipReference + ", " : "")
                + ((legalReference != null) ? "legalReference=" + legalReference + ", " : "")
                + ((issueDate != null) ? "issueDate=" + issueDate + ", " : "")
                + ((dueDate != null) ? "dueDate=" + dueDate + ", " : "")
                + ((creditDate != null) ? "creditDate=" + creditDate + ", " : "")
                + ((instructionCode != null) ? "instructionCode=" + instructionCode + ", " : "")
                + ((instructionNumber != null) ? "instructionNumber=" + instructionNumber + ", " : "")
                + ((bankInstructionCode != null) ? "bankInstructionCode=" + bankInstructionCode + ", " : "")
                + ((issuerBankCode != null) ? "issuerBankCode=" + issuerBankCode + ", " : "")
                + ((issuerBranch != null) ? "issuerBranch=" + issuerBranch + ", " : "")
                + ((collectorBankCode != null) ? "collectorBankCode=" + collectorBankCode + ", " : "")
                + ((collectorBranch != null) ? "collectorBranch=" + collectorBranch + ", " : "")
                + ((comments != null) ? "comments=" + comments + ", " : "")
                + ((penaltyAmount != null) ? "penaltyAmount=" + penaltyAmount + ", " : "")
                + ((discountAmount != null) ? "discountAmount=" + discountAmount + ", " : "")
                + ((status != null) ? "status=" + status + ", " : "")
                + ((bankStatus != null) ? "bankStatus=" + bankStatus + ", " : "")
                + ((rejectionReason != null) ? "rejectionReason=" + rejectionReason + ", " : "")
                + ((currencyCode != null) ? "currencyCode=" + currencyCode + ", " : "")
                + ((amount != null) ? "amount=" + amount : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        PaymentInstrument that = (PaymentInstrument) o;

        if (depositSlipIssueDate != null ? !depositSlipIssueDate.equals(that.depositSlipIssueDate) : that.depositSlipIssueDate != null) return false;
        if (depositSlipTotalAmount != null ? !depositSlipTotalAmount.equals(that.depositSlipTotalAmount) : that.depositSlipTotalAmount != null) return false;
        if (depositSlipReference != null ? !depositSlipReference.equals(that.depositSlipReference) : that.depositSlipReference != null) return false;
        if (legalReference != null ? !legalReference.equals(that.legalReference) : that.legalReference != null) return false;
        if (issueDate != null ? !issueDate.equals(that.issueDate) : that.issueDate != null) return false;
        if (dueDate != null ? !dueDate.equals(that.dueDate) : that.dueDate != null) return false;
        if (creditDate != null ? !creditDate.equals(that.creditDate) : that.creditDate != null) return false;
        if (instructionCode != that.instructionCode) return false;
        if (instructionNumber != null ? !instructionNumber.equals(that.instructionNumber) : that.instructionNumber != null) return false;
        if (bankInstructionCode != null ? !bankInstructionCode.equals(that.bankInstructionCode) : that.bankInstructionCode != null) return false;
        if (issuerBankCode != null ? !issuerBankCode.equals(that.issuerBankCode) : that.issuerBankCode != null) return false;
        if (issuerBranch != null ? !issuerBranch.equals(that.issuerBranch) : that.issuerBranch != null) return false;
        if (collectorBankCode != null ? !collectorBankCode.equals(that.collectorBankCode) : that.collectorBankCode != null) return false;
        if (collectorBranch != null ? !collectorBranch.equals(that.collectorBranch) : that.collectorBranch != null) return false;
        if (comments != null ? !comments.equals(that.comments) : that.comments != null) return false;
        if (penaltyAmount != null ? !penaltyAmount.equals(that.penaltyAmount) : that.penaltyAmount != null) return false;
        if (discountAmount != null ? !discountAmount.equals(that.discountAmount) : that.discountAmount != null) return false;
        if (status != that.status) return false;
        if (bankStatus != null ? !bankStatus.equals(that.bankStatus) : that.bankStatus != null) return false;
        if (rejectionReason != null ? !rejectionReason.equals(that.rejectionReason) : that.rejectionReason != null) return false;
        if (currencyCode != null ? !currencyCode.equals(that.currencyCode) : that.currencyCode != null) return false;
        return amount != null ? amount.equals(that.amount) : that.amount == null;
    }

    @Override
    public int hashCode() {
        int result = depositSlipIssueDate != null ? depositSlipIssueDate.hashCode() : 0;
        result = 31 * result + (depositSlipTotalAmount != null ? depositSlipTotalAmount.hashCode() : 0);
        result = 31 * result + (depositSlipReference != null ? depositSlipReference.hashCode() : 0);
        result = 31 * result + (legalReference != null ? legalReference.hashCode() : 0);
        result = 31 * result + (issueDate != null ? issueDate.hashCode() : 0);
        result = 31 * result + (dueDate != null ? dueDate.hashCode() : 0);
        result = 31 * result + (creditDate != null ? creditDate.hashCode() : 0);
        result = 31 * result + (instructionCode != null ? instructionCode.hashCode() : 0);
        result = 31 * result + (instructionNumber != null ? instructionNumber.hashCode() : 0);
        result = 31 * result + (bankInstructionCode != null ? bankInstructionCode.hashCode() : 0);
        result = 31 * result + (issuerBankCode != null ? issuerBankCode.hashCode() : 0);
        result = 31 * result + (issuerBranch != null ? issuerBranch.hashCode() : 0);
        result = 31 * result + (collectorBankCode != null ? collectorBankCode.hashCode() : 0);
        result = 31 * result + (collectorBranch != null ? collectorBranch.hashCode() : 0);
        result = 31 * result + (comments != null ? comments.hashCode() : 0);
        result = 31 * result + (penaltyAmount != null ? penaltyAmount.hashCode() : 0);
        result = 31 * result + (discountAmount != null ? discountAmount.hashCode() : 0);
        result = 31 * result + (status != null ? status.hashCode() : 0);
        result = 31 * result + (bankStatus != null ? bankStatus.hashCode() : 0);
        result = 31 * result + (rejectionReason != null ? rejectionReason.hashCode() : 0);
        result = 31 * result + (currencyCode != null ? currencyCode.hashCode() : 0);
        result = 31 * result + (amount != null ? amount.hashCode() : 0);
        return result;
    }
}

