package ar.com.sdd.banconnector.api.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PaymentInstrumentImageSet implements Serializable {

    private Long trackingNumber = null;
    private String bankTrackingNumber = null;
    private String ownerCuit = null;
    private String agreementCode = null;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date processDate = null;
    private List<PaymentInstrumentImage> paymentInstrumentImages = new ArrayList<PaymentInstrumentImage>();

    public PaymentInstrumentImageSet() {

    }

    /**
     * Número de seguimiento
     **/


    @JsonProperty("trackingNumber")
    @NotNull
    public Long getTrackingNumber() {
        return trackingNumber;
    }

    public void setTrackingNumber(Long trackingNumber) {
        this.trackingNumber = trackingNumber;
    }

    /**
     * Número de seguimiento del sistema interno del banco
     **/


    @JsonProperty("bankTrackingNumber")
    @Size(max = 10)
    public String getBankTrackingNumber() {
        return bankTrackingNumber;
    }

    public void setBankTrackingNumber(String bankTrackingNumber) {
        this.bankTrackingNumber = bankTrackingNumber;
    }

    /**
     * CUIT del propietario de las cuentas (sin guiones ni espacios)
     **/


    @JsonProperty("ownerCuit")
    @NotNull
    @Size(max = 11)
    public String getOwnerCuit() {
        return ownerCuit;
    }

    public void setOwnerCuit(String ownerCuit) {
        this.ownerCuit = ownerCuit;
    }

    /**
     * Código de acuerdo
     **/


    @JsonProperty("agreementCode")
    @NotNull
    @Size(max = 50)
    public String getAgreementCode() {
        return agreementCode;
    }

    public void setAgreementCode(String agreementCode) {
        this.agreementCode = agreementCode;
    }

    /**
     * Fecha de la publicación
     **/


    @JsonProperty("processDate")
    @NotNull
    public Date getProcessDate() {
        return processDate;
    }

    public void setProcessDate(Date processDate) {
        this.processDate = processDate;
    }

    /**
     * Lista de imágenes de instrumentos
     **/


    @JsonProperty("paymentInstrumentImages")
    @NotNull
    public List<PaymentInstrumentImage> getPaymentInstrumentImages() {
        return paymentInstrumentImages;
    }

    public void setPaymentInstrumentImages(List<PaymentInstrumentImage> paymentInstrumentImages) {
        this.paymentInstrumentImages = paymentInstrumentImages;
    }

    @Override
    public String toString() {
        return "PaymentInstrumentImageSet ["
                + ((trackingNumber != null) ? "trackingNumber=" + trackingNumber + ", " : "")
                + ((bankTrackingNumber != null) ? "bankTrackingNumber=" + bankTrackingNumber + ", " : "")
                + ((ownerCuit != null) ? "ownerCuit=" + ownerCuit + ", " : "")
                + ((agreementCode != null) ? "agreementCode=" + agreementCode + ", " : "")
                + ((processDate != null) ? "processDate=" + processDate + ", " : "")
                + ((paymentInstrumentImages != null) ? "paymentInstrumentImages=" + Arrays.toString(paymentInstrumentImages.toArray()) : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        PaymentInstrumentImageSet that = (PaymentInstrumentImageSet) o;

        if (trackingNumber != null ? !trackingNumber.equals(that.trackingNumber) : that.trackingNumber != null) return false;
        if (bankTrackingNumber != null ? !bankTrackingNumber.equals(that.bankTrackingNumber) : that.bankTrackingNumber != null) return false;
        if (ownerCuit != null ? !ownerCuit.equals(that.ownerCuit) : that.ownerCuit != null) return false;
        if (agreementCode != null ? !agreementCode.equals(that.agreementCode) : that.agreementCode != null) return false;
        if (processDate != null ? !processDate.equals(that.processDate) : that.processDate != null) return false;
        return paymentInstrumentImages != null ? paymentInstrumentImages.equals(that.paymentInstrumentImages) : that.paymentInstrumentImages == null;
    }

    @Override
    public int hashCode() {
        int result = trackingNumber != null ? trackingNumber.hashCode() : 0;
        result = 31 * result + (bankTrackingNumber != null ? bankTrackingNumber.hashCode() : 0);
        result = 31 * result + (ownerCuit != null ? ownerCuit.hashCode() : 0);
        result = 31 * result + (agreementCode != null ? agreementCode.hashCode() : 0);
        result = 31 * result + (processDate != null ? processDate.hashCode() : 0);
        result = 31 * result + (paymentInstrumentImages != null ? paymentInstrumentImages.hashCode() : 0);
        return result;
    }
}

