package ar.com.sdd.banconnector.api;

import ar.com.sdd.banconnector.api.model.Balance;
import ar.com.sdd.commons.rest.log.ServerFileLogged;

import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Path("/balances")
public class BalancesApi {

    @Inject
    BalancesApiService service;

    @POST
    @ServerFileLogged
    @Path("/owner/{ownerCuit}/balances")
    @Consumes({"application/json"})
    public Response postBalance(@HeaderParam("Bearer") String bearer, @PathParam("ownerCuit") String ownerCuit, Balance balance, @Context SecurityContext securityContext)
            throws NotFoundException {
        return service.postBalance(bearer, ownerCuit, balance, securityContext);
    }
}
