package ar.com.sdd.banconnector.api.model;

import com.fasterxml.jackson.annotation.JsonValue;

public interface BanconnectorEnum {

    /**
     * Condición de IVA del pagador. Segun Tipos de Responsables AFIP
     */
    enum TaxCodeEnum {
        IVA_RI("IVA_RI"),

        IVA_RNI("IVA_RNI"),

        IVA_NR("IVA_NR"),

        IVA_EX("IVA_EX"),

        CON_FINAL("CON_FINAL"),

        RES_MONO("RES_MONO"),

        SUJ_NO_CAT("SUJ_NO_CAT"),

        PROV_EXT("PROV_EXT"),

        CLI_EXT("CLI_EXT"),

        IVA_LIB("IVA_LIB"),

        IVA_RI_AG_PER("IVA_RI_AG_PER"),

        PEQ_CONT_EV("PEQ_CONT_EV"),

        MON_SOC("MON_SOC"),

        PEQ_CONT_EV_SOC("PEQ_CONT_EV_SOC");
        private String value;

        TaxCodeEnum(String value) {
            this.value = value;
        }

        @Override
        @JsonValue
        public String toString() {
            return String.valueOf(value);
        }
    }

    /**
     * Condición de IIBB del pagador
     */
    enum TaxCode2Enum {
        EXE("EXE"),

        LOC("LOC"),

        MUL("MUL"),

        NOI("NOI");
        private String value;

        TaxCode2Enum(String value) {
            this.value = value;
        }

        @Override
        @JsonValue
        public String toString() {
            return String.valueOf(value);
        }
    }

    /**
     * Gets or Sets instructionCodes
     */
    enum InstructionCodesEnum {
        EFEC("EFEC"),

        CHEQ("CHEQ"),

        TRAN("TRAN"),

        CPD("CPD");
        private String value;

        InstructionCodesEnum(String value) {
            this.value = value;
        }

        @Override
        @JsonValue
        public String toString() {
            return String.valueOf(value);
        }
    }

    /**
     * Indica si el envío debe ser considerado como un FULL-REFRESH, o INCREMENTAL
     */
    enum PublicationModeEnum {
        FULLREFRESH("FULLREFRESH"),

        INCREMENTAL("INCREMENTAL");
        private String value;

        PublicationModeEnum(String value) {
            this.value = value;
        }

        @Override
        @JsonValue
        public String toString() {
            return String.valueOf(value);
        }
    }

    /**
     * Estado de la publicación de este documento
     */
    enum StatusEnum {
        PENDING("PENDING"),

        PUBLISHED("PUBLISHED"),

        ERROR("ERROR");
        private String value;

        StatusEnum(String value) {
            this.value = value;
        }

        @Override
        @JsonValue
        public String toString() {
            return String.valueOf(value);
        }
    }

}
