/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.banconnector.api;

import ar.com.sdd.banconnector.api.CustomersApiService;
import ar.com.sdd.banconnector.api.model.CustomerSetStatus;
import ar.com.sdd.commons.rest.log.ServerFileLogged;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Path(value="/customers")
public class CustomersApi {
    @Inject
    CustomersApiService service;

    @GET
    @ServerFileLogged
    @Path(value="/owner/{ownerCuit}/agreement/{agreementCode}/customer-sets")
    @Produces(value={"application/json; charset=utf-8"})
    public Response getCustomerSet(@HeaderParam(value="Bearer") String bearer, @PathParam(value="ownerCuit") String ownerCuit, @PathParam(value="agreementCode") String agreementCode, @QueryParam(value="trackingNumber") Long trackingNumber, @QueryParam(value="offset") Integer offset, @QueryParam(value="limit") Integer limit, @Context SecurityContext securityContext) {
        return this.service.getCustomerSet(bearer, ownerCuit, agreementCode, trackingNumber, offset, limit, securityContext);
    }

    @POST
    @ServerFileLogged
    @Path(value="/owner/{ownerCuit}/agreement/{agreementCode}/customer-sets/{referencedTrackingNumber}/status")
    @Consumes(value={"application/json"})
    public Response postCustomerSetStatus(@HeaderParam(value="Bearer") String bearer, @PathParam(value="ownerCuit") String ownerCuit, @PathParam(value="agreementCode") String agreementCode, @PathParam(value="referencedTrackingNumber") Long referencedTrackingNumber, CustomerSetStatus customerSetStatus, @Context SecurityContext securityContext) {
        return this.service.postCustomerSetStatus(bearer, ownerCuit, agreementCode, referencedTrackingNumber, customerSetStatus, securityContext);
    }
}

