package ar.com.sdd.banconnector.api.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.math.BigDecimal;
import java.util.Date;


@JsonIgnoreProperties(ignoreUnknown = true)
public class DebitInstructionItem {


    /**
     * Tipo de documento * DI: Instrucción de débito
     */
    public enum TypeEnum {
        DI("DI");
        private String value;

        TypeEnum(String value) {
            this.value = value;
        }

        @Override
        @JsonValue
        public String toString() {
            return String.valueOf(value);
        }
    }

    /**
     * Marca de débito/crédito * D: Instrucción de débito * C: Instrucción de crédito
     */
    public enum DebitCreditMarkEnum {
        D("D"),

        C("C");
        private String value;

        DebitCreditMarkEnum(String value) {
            this.value = value;
        }

        @Override
        @JsonValue
        public String toString() {
            return String.valueOf(value);
        }
    }

    private TypeEnum type = null;
    private String legalReference = null;
    private String ownerReference = null;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date issueDate = null;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date dueDate = null;
    private BigDecimal dueAmount = null;
    private DebitCreditMarkEnum debitCreditMark = null;
    private String currencyCode = null;
    private String comments = null;
    private String instrumentReference = null;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date instrumentDueDate = null;
    private String verificationCode = null;
    private String installmentType = null;
    private Integer installments = null;
    private String payerReference = null;
    private String payerName = null;
    private String payerCuit = null;
    private String payerConcept = null;
    private String payerEmail = null;

    /**
     * Tipo de documento * DI: Instrucción de débito
     **/

    @JsonProperty("type")
    @NotNull
    public TypeEnum getType() {
        return type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    /**
     * Identificador de la instrucción
     **/

    @JsonProperty("legalReference")
    @NotNull
    @Size(max = 255)
    public String getLegalReference() {
        return legalReference;
    }

    public void setLegalReference(String legalReference) {
        this.legalReference = legalReference;
    }

    /**
     * Identificador interno de la compañía
     **/

    @JsonProperty("ownerReference")
    @Size(max = 255)
    public String getOwnerReference() {
        return ownerReference;
    }

    public void setOwnerReference(String ownerReference) {
        this.ownerReference = ownerReference;
    }

    /**
     * Fecha de emisión de la instrucción
     **/

    @JsonProperty("issueDate")
    public Date getIssueDate() {
        return issueDate;
    }

    public void setIssueDate(Date issueDate) {
        this.issueDate = issueDate;
    }

    /**
     * Fecha de vencimiento de la instrucción
     **/

    @JsonProperty("dueDate")
    public Date getDueDate() {
        return dueDate;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    /**
     * [15.2]Monto de la instrucción
     **/

    @JsonProperty("dueAmount")
    @NotNull
    public BigDecimal getDueAmount() {
        return dueAmount;
    }

    public void setDueAmount(BigDecimal dueAmount) {
        this.dueAmount = dueAmount;
    }

    /**
     * Marca de débito/crédito * D: Instrucción de débito * C: Instrucción de crédito
     **/

    @JsonProperty("debitCreditMark")
    public DebitCreditMarkEnum getDebitCreditMark() {
        return debitCreditMark;
    }

    public void setDebitCreditMark(DebitCreditMarkEnum debitCreditMark) {
        this.debitCreditMark = debitCreditMark;
    }

    /**
     * Código de moneda ISO 4217
     **/

    @JsonProperty("currencyCode")
    @Size(max = 3)
    public String getCurrencyCode() {
        return currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    /**
     * Texto libre
     **/

    @JsonProperty("comments")
    @Size(max = 200)
    public String getComments() {
        return comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    /**
     * Referencia del instrumento utilizado, por ejemplo el número de una TC
     **/

    @JsonProperty("instrumentReference")
    @Size(max = 50)
    public String getInstrumentReference() {
        return instrumentReference;
    }

    public void setInstrumentReference(String instrumentReference) {
        this.instrumentReference = instrumentReference;
    }

    /**
     * Fecha de vencimiento del instrumento
     **/

    @JsonProperty("instrumentDueDate")
    public Date getInstrumentDueDate() {
        return instrumentDueDate;
    }

    public void setInstrumentDueDate(Date instrumentDueDate) {
        this.instrumentDueDate = instrumentDueDate;
    }

    /**
     * Código de verificación, por ejemplo el CVC de una TC
     **/

    @JsonProperty("verificationCode")
    @Size(max = 50)
    public String getVerificationCode() {
        return verificationCode;
    }

    public void setVerificationCode(String verificationCode) {
        this.verificationCode = verificationCode;
    }

    /**
     * Plan de cuotas
     **/

    @JsonProperty("installmentType")
    @Size(max = 200)
    public String getInstallmentType() {
        return installmentType;
    }

    public void setInstallmentType(String installmentType) {
        this.installmentType = installmentType;
    }

    /**
     * Cantidad de cuotas
     **/

    @JsonProperty("installments")
    public Integer getInstallments() {
        return installments;
    }

    public void setInstallments(Integer installments) {
        this.installments = installments;
    }

    /**
     * Identificador del pagador
     **/

    @JsonProperty("payerReference")
    @NotNull
    @Size(max = 255)
    public String getPayerReference() {
        return payerReference;
    }

    public void setPayerReference(String payerReference) {
        this.payerReference = payerReference;
    }

    /**
     * Razón social del pagador
     **/

    @JsonProperty("payerName")
    @Size(max = 255)
    public String getPayerName() {
        return payerName;
    }

    public void setPayerName(String payerName) {
        this.payerName = payerName;
    }

    /**
     * CUIT del pagador
     **/

    @JsonProperty("payerCuit")
    @Size(max = 11)
    public String getPayerCuit() {
        return payerCuit;
    }

    public void setPayerCuit(String payerCuit) {
        this.payerCuit = payerCuit;
    }

    /**
     * Categorización del cliente dentro de la compañía
     **/

    @JsonProperty("payerConcept")
    @Size(max = 255)
    public String getPayerConcept() {
        return payerConcept;
    }

    public void setPayerConcept(String payerConcept) {
        this.payerConcept = payerConcept;
    }

    /**
     * Correo electrónico del pagador
     **/

    @JsonProperty("payerEmail")
    @Size(max = 150)
    public String getPayerEmail() {
        return payerEmail;
    }

    public void setPayerEmail(String payerEmail) {
        this.payerEmail = payerEmail;
    }

    @Override
    public String toString() {
        return "DebitInstructionItem ["
                + ((type != null) ? "type=" + type + ", " : "")
                + ((legalReference != null) ? "legalReference=" + legalReference + ", " : "")
                + ((ownerReference != null) ? "ownerReference=" + ownerReference + ", " : "")
                + ((issueDate != null) ? "issueDate=" + issueDate + ", " : "")
                + ((dueDate != null) ? "dueDate=" + dueDate + ", " : "")
                + ((dueAmount != null) ? "dueAmount=" + dueAmount + ", " : "")
                + ((debitCreditMark != null) ? "debitCreditMark=" + debitCreditMark + ", " : "")
                + ((currencyCode != null) ? "currencyCode=" + currencyCode + ", " : "")
                + ((comments != null) ? "comments=" + comments + ", " : "")
                + ((instrumentReference != null) ? "instrumentReference=" + instrumentReference + ", " : "")
                + ((instrumentDueDate != null) ? "instrumentDueDate=" + instrumentDueDate + ", " : "")
                + ((verificationCode != null) ? "verificationCode=" + verificationCode + ", " : "")
                + ((installmentType != null) ? "installmentType=" + installmentType + ", " : "")
                + ((installments != null) ? "installments=" + installments + ", " : "")
                + ((payerReference != null) ? "payerReference=" + payerReference + ", " : "")
                + ((payerName != null) ? "payerName=" + payerName + ", " : "")
                + ((payerCuit != null) ? "payerCuit=" + payerCuit + ", " : "")
                + ((payerConcept != null) ? "payerConcept=" + payerConcept + ", " : "")
                + ((payerEmail != null) ? "payerEmail=" + payerEmail : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        DebitInstructionItem that = (DebitInstructionItem) o;

        if (type != that.type) return false;
        if (legalReference != null ? !legalReference.equals(that.legalReference) : that.legalReference != null) return false;
        if (ownerReference != null ? !ownerReference.equals(that.ownerReference) : that.ownerReference != null) return false;
        if (issueDate != null ? !issueDate.equals(that.issueDate) : that.issueDate != null) return false;
        if (dueDate != null ? !dueDate.equals(that.dueDate) : that.dueDate != null) return false;
        if (dueAmount != null ? !dueAmount.equals(that.dueAmount) : that.dueAmount != null) return false;
        if (debitCreditMark != that.debitCreditMark) return false;
        if (currencyCode != null ? !currencyCode.equals(that.currencyCode) : that.currencyCode != null) return false;
        if (comments != null ? !comments.equals(that.comments) : that.comments != null) return false;
        if (instrumentReference != null ? !instrumentReference.equals(that.instrumentReference) : that.instrumentReference != null) return false;
        if (instrumentDueDate != null ? !instrumentDueDate.equals(that.instrumentDueDate) : that.instrumentDueDate != null) return false;
        if (verificationCode != null ? !verificationCode.equals(that.verificationCode) : that.verificationCode != null) return false;
        if (installmentType != null ? !installmentType.equals(that.installmentType) : that.installmentType != null) return false;
        if (installments != null ? !installments.equals(that.installments) : that.installments != null) return false;
        if (payerReference != null ? !payerReference.equals(that.payerReference) : that.payerReference != null) return false;
        if (payerName != null ? !payerName.equals(that.payerName) : that.payerName != null) return false;
        if (payerCuit != null ? !payerCuit.equals(that.payerCuit) : that.payerCuit != null) return false;
        if (payerConcept != null ? !payerConcept.equals(that.payerConcept) : that.payerConcept != null) return false;
        return payerEmail != null ? payerEmail.equals(that.payerEmail) : that.payerEmail == null;
    }

    @Override
    public int hashCode() {
        int result = type != null ? type.hashCode() : 0;
        result = 31 * result + (legalReference != null ? legalReference.hashCode() : 0);
        result = 31 * result + (ownerReference != null ? ownerReference.hashCode() : 0);
        result = 31 * result + (issueDate != null ? issueDate.hashCode() : 0);
        result = 31 * result + (dueDate != null ? dueDate.hashCode() : 0);
        result = 31 * result + (dueAmount != null ? dueAmount.hashCode() : 0);
        result = 31 * result + (debitCreditMark != null ? debitCreditMark.hashCode() : 0);
        result = 31 * result + (currencyCode != null ? currencyCode.hashCode() : 0);
        result = 31 * result + (comments != null ? comments.hashCode() : 0);
        result = 31 * result + (instrumentReference != null ? instrumentReference.hashCode() : 0);
        result = 31 * result + (instrumentDueDate != null ? instrumentDueDate.hashCode() : 0);
        result = 31 * result + (verificationCode != null ? verificationCode.hashCode() : 0);
        result = 31 * result + (installmentType != null ? installmentType.hashCode() : 0);
        result = 31 * result + (installments != null ? installments.hashCode() : 0);
        result = 31 * result + (payerReference != null ? payerReference.hashCode() : 0);
        result = 31 * result + (payerName != null ? payerName.hashCode() : 0);
        result = 31 * result + (payerCuit != null ? payerCuit.hashCode() : 0);
        result = 31 * result + (payerConcept != null ? payerConcept.hashCode() : 0);
        result = 31 * result + (payerEmail != null ? payerEmail.hashCode() : 0);
        return result;
    }

}

