package ar.com.sdd.banconnector.api.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Statement implements Serializable {

    /**
     * Marca de debito o credito
     */
    public enum DebitCreditMarkEnum {
        D("D"),

        C("C");

        private String value;

        DebitCreditMarkEnum(String value) {
            this.value = value;
        }

        @Override
        @JsonValue
        public String toString() {
            return String.valueOf(value);
        }
    }

    private String accountReference = null;
    private String bankReference = null;
    private String issuerReference = null;
    private String issuerCuit = null;
    private String issuerPO = null;
    private String referenceGroup = null;
    private PayerReference payerReference = null;
    private String type = null;
    private String status = null;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ssXXX", timezone = "GMT-03:00")
    private Date depositDateTime = null;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date issueDate = null;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date dueDate = null;
    private String issuerBankCode = null;
    private String issuerBranch = null;
    private String collectorBankCode = null;
    private String collectorBranch = null;
    private String currencyCode = null;
    private DebitCreditMarkEnum debitCreditMark = null;
    private BigDecimal amount = null;
    private String comments = null;

    public Statement() {

    }

    /**
     * Número de cuenta
     **/


    @JsonProperty("accountReference")
    @NotNull
    @Size(max = 255)
    public String getAccountReference() {
        return accountReference;
    }

    public void setAccountReference(String accountReference) {
        this.accountReference = accountReference;
    }

    /**
     * Referencia interna del movimiento. CAMPO CLAVE (con este campo se determina creación o actualización).
     **/


    @JsonProperty("bankReference")
    @NotNull
    @Size(max = 255)
    public String getBankReference() {
        return bankReference;
    }

    public void setBankReference(String bankReference) {
        this.bankReference = bankReference;
    }

    /**
     * Referencia generada por el emisor del movimiento
     **/


    @JsonProperty("issuerReference")
    @Size(max = 255)
    public String getIssuerReference() {
        return issuerReference;
    }

    public void setIssuerReference(String issuerReference) {
        this.issuerReference = issuerReference;
    }

    /**
     * CUIT del emisor del movimiento
     **/


    @JsonProperty("issuerCuit")
    @Size(max = 11)
    public String getIssuerCuit() {
        return issuerCuit;
    }

    public void setIssuerCuit(String issuerCuit) {
        this.issuerCuit = issuerCuit;
    }

    /**
     * Código postal del emisor del movimiento
     **/


    @JsonProperty("issuerPO")
    @Size(max = 255)
    public String getIssuerPO() {
        return issuerPO;
    }

    public void setIssuerPO(String issuerPO) {
        this.issuerPO = issuerPO;
    }

    /**
     * Referencia para agrupar conjuntos de movimientos
     **/


    @JsonProperty("referenceGroup")
    @Size(max = 255)
    public String getReferenceGroup() {
        return referenceGroup;
    }

    public void setReferenceGroup(String referenceGroup) {
        this.referenceGroup = referenceGroup;
    }

    /**
     **/


    @JsonProperty("payerReference")
    public PayerReference getPayerReference() {
        return payerReference;
    }

    public void setPayerReference(PayerReference payerReference) {
        this.payerReference = payerReference;
    }

    /**
     * Tipo de movimiento
     **/


    @JsonProperty("type")
    @NotNull
    @Size(max = 20)
    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    /**
     * Estado del movimiento
     **/


    @JsonProperty("status")
    @Size(max = 20)
    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    /**
     * Fecha y hora del depósito del movimiento
     **/


    @JsonProperty("depositDateTime")
    @NotNull
    public Date getDepositDateTime() {
        return depositDateTime;
    }

    public void setDepositDateTime(Date depositDateTime) {
        this.depositDateTime = depositDateTime;
    }

    /**
     * Fecha de emisión
     **/


    @JsonProperty("issueDate")
    public Date getIssueDate() {
        return issueDate;
    }

    public void setIssueDate(Date issueDate) {
        this.issueDate = issueDate;
    }

    /**
     * Fecha de vencimiento
     **/


    @JsonProperty("dueDate")
    public Date getDueDate() {
        return dueDate;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    /**
     * Código de banco emisor
     **/


    @JsonProperty("issuerBankCode")
    @Size(max = 50)
    public String getIssuerBankCode() {
        return issuerBankCode;
    }

    public void setIssuerBankCode(String issuerBankCode) {
        this.issuerBankCode = issuerBankCode;
    }

    /**
     * Sucursal de banco emisor
     **/


    @JsonProperty("issuerBranch")
    @Size(max = 50)
    public String getIssuerBranch() {
        return issuerBranch;
    }

    public void setIssuerBranch(String issuerBranch) {
        this.issuerBranch = issuerBranch;
    }

    /**
     * Código de banco depósito
     **/


    @JsonProperty("collectorBankCode")
    @Size(max = 50)
    public String getCollectorBankCode() {
        return collectorBankCode;
    }

    public void setCollectorBankCode(String collectorBankCode) {
        this.collectorBankCode = collectorBankCode;
    }

    /**
     * Sucursal de banco depósito
     **/


    @JsonProperty("collectorBranch")
    @Size(max = 50)
    public String getCollectorBranch() {
        return collectorBranch;
    }

    public void setCollectorBranch(String collectorBranch) {
        this.collectorBranch = collectorBranch;
    }

    /**
     * Código de moneda ISO 4217
     **/


    @JsonProperty("currencyCode")
    @Size(max = 3)
    public String getCurrencyCode() {
        return currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    @JsonProperty("debitCreditMark")
    public DebitCreditMarkEnum getDebitCreditMark() {
        return debitCreditMark;
    }

    public void setDebitCreditMark(DebitCreditMarkEnum debitCreditMark) {
        this.debitCreditMark = debitCreditMark;
    }

    /**
     * [15.2]Monto del movimiento
     **/


    @JsonProperty("amount")
    @NotNull
    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    /**
     * Texto libre
     **/


    @JsonProperty("comments")
    @Size(max = 200)
    public String getComments() {
        return comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    @Override
    public String toString() {
        return "Statement ["
                + ((accountReference != null) ? "accountReference=" + accountReference + ", " : "")
                + ((bankReference != null) ? "bankReference=" + bankReference + ", " : "")
                + ((issuerReference != null) ? "issuerReference=" + issuerReference + ", " : "")
                + ((issuerCuit != null) ? "issuerCuit=" + issuerCuit + ", " : "")
                + ((issuerPO != null) ? "issuerPO=" + issuerPO + ", " : "")
                + ((referenceGroup != null) ? "referenceGroup=" + referenceGroup + ", " : "")
                + ((payerReference != null) ? "payerReference=" + payerReference + ", " : "")
                + ((type != null) ? "type=" + type + ", " : "")
                + ((status != null) ? "status=" + status + ", " : "")
                + ((depositDateTime != null) ? "depositDateTime=" + depositDateTime + ", " : "")
                + ((issueDate != null) ? "issueDate=" + issueDate + ", " : "")
                + ((dueDate != null) ? "dueDate=" + dueDate + ", " : "")
                + ((issuerBankCode != null) ? "issuerBankCode=" + issuerBankCode + ", " : "")
                + ((issuerBranch != null) ? "issuerBranch=" + issuerBranch + ", " : "")
                + ((collectorBankCode != null) ? "collectorBankCode=" + collectorBankCode + ", " : "")
                + ((collectorBranch != null) ? "collectorBranch=" + collectorBranch + ", " : "")
                + ((currencyCode != null) ? "currencyCode=" + currencyCode + ", " : "")
                + ((amount != null) ? "amount=" + amount + ", " : "")
                + ((comments != null) ? "comments=" + comments : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Statement statement = (Statement) o;

        if (accountReference != null ? !accountReference.equals(statement.accountReference) : statement.accountReference != null) return false;
        if (bankReference != null ? !bankReference.equals(statement.bankReference) : statement.bankReference != null) return false;
        if (issuerReference != null ? !issuerReference.equals(statement.issuerReference) : statement.issuerReference != null) return false;
        if (issuerCuit != null ? !issuerCuit.equals(statement.issuerCuit) : statement.issuerCuit != null) return false;
        if (issuerPO != null ? !issuerPO.equals(statement.issuerPO) : statement.issuerPO != null) return false;
        if (referenceGroup != null ? !referenceGroup.equals(statement.referenceGroup) : statement.referenceGroup != null) return false;
        if (payerReference != null ? !payerReference.equals(statement.payerReference) : statement.payerReference != null) return false;
        if (type != null ? !type.equals(statement.type) : statement.type != null) return false;
        if (status != null ? !status.equals(statement.status) : statement.status != null) return false;
        if (depositDateTime != null ? !depositDateTime.equals(statement.depositDateTime) : statement.depositDateTime != null) return false;
        if (issueDate != null ? !issueDate.equals(statement.issueDate) : statement.issueDate != null) return false;
        if (dueDate != null ? !dueDate.equals(statement.dueDate) : statement.dueDate != null) return false;
        if (issuerBankCode != null ? !issuerBankCode.equals(statement.issuerBankCode) : statement.issuerBankCode != null) return false;
        if (issuerBranch != null ? !issuerBranch.equals(statement.issuerBranch) : statement.issuerBranch != null) return false;
        if (collectorBankCode != null ? !collectorBankCode.equals(statement.collectorBankCode) : statement.collectorBankCode != null) return false;
        if (collectorBranch != null ? !collectorBranch.equals(statement.collectorBranch) : statement.collectorBranch != null) return false;
        if (currencyCode != null ? !currencyCode.equals(statement.currencyCode) : statement.currencyCode != null) return false;
        if (amount != null ? !amount.equals(statement.amount) : statement.amount != null) return false;
        return comments != null ? comments.equals(statement.comments) : statement.comments == null;
    }

    @Override
    public int hashCode() {
        int result = accountReference != null ? accountReference.hashCode() : 0;
        result = 31 * result + (bankReference != null ? bankReference.hashCode() : 0);
        result = 31 * result + (issuerReference != null ? issuerReference.hashCode() : 0);
        result = 31 * result + (issuerCuit != null ? issuerCuit.hashCode() : 0);
        result = 31 * result + (issuerPO != null ? issuerPO.hashCode() : 0);
        result = 31 * result + (referenceGroup != null ? referenceGroup.hashCode() : 0);
        result = 31 * result + (payerReference != null ? payerReference.hashCode() : 0);
        result = 31 * result + (type != null ? type.hashCode() : 0);
        result = 31 * result + (status != null ? status.hashCode() : 0);
        result = 31 * result + (depositDateTime != null ? depositDateTime.hashCode() : 0);
        result = 31 * result + (issueDate != null ? issueDate.hashCode() : 0);
        result = 31 * result + (dueDate != null ? dueDate.hashCode() : 0);
        result = 31 * result + (issuerBankCode != null ? issuerBankCode.hashCode() : 0);
        result = 31 * result + (issuerBranch != null ? issuerBranch.hashCode() : 0);
        result = 31 * result + (collectorBankCode != null ? collectorBankCode.hashCode() : 0);
        result = 31 * result + (collectorBranch != null ? collectorBranch.hashCode() : 0);
        result = 31 * result + (currencyCode != null ? currencyCode.hashCode() : 0);
        result = 31 * result + (amount != null ? amount.hashCode() : 0);
        result = 31 * result + (comments != null ? comments.hashCode() : 0);
        return result;
    }
}

