package ar.com.sdd.banconnector.api;

import ar.com.sdd.banconnector.api.model.CustomerSetStatus;
import ar.com.sdd.commons.rest.log.ServerFileLogged;

import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Path("/banconnector/v1_1/customers")
public class CustomersApi {

    @Inject
    CustomersApiService service;

    @GET
    @ServerFileLogged
    @Path("/owner/{ownerCuit}/agreement/{agreementCode}/customer-sets")
    @Produces("application/json; charset=utf-8")
    public Response getCustomerSet(@HeaderParam("Bearer") String bearer, @PathParam("ownerCuit") String ownerCuit, @PathParam("agreementCode") String agreementCode, @QueryParam("trackingNumber") Long trackingNumber, @QueryParam("offset") Integer offset, @QueryParam("limit") Integer limit, @Context SecurityContext securityContext) {
        return service.getCustomerSet(bearer, ownerCuit, agreementCode, trackingNumber, offset, limit, securityContext);
    }

    @POST
    @ServerFileLogged
    @Path("/owner/{ownerCuit}/agreement/{agreementCode}/customer-sets/{referencedTrackingNumber}/status")
    @Consumes({"application/json"})
    public Response postCustomerSetStatus(@HeaderParam("Bearer") String bearer, @PathParam("ownerCuit") String ownerCuit, @PathParam("agreementCode") String agreementCode, @PathParam("referencedTrackingNumber") Long referencedTrackingNumber, CustomerSetStatus customerSetStatus, @Context SecurityContext securityContext) {
        return service.postCustomerSetStatus(bearer, ownerCuit, agreementCode, referencedTrackingNumber, customerSetStatus, securityContext);
    }
}
