package ar.com.sdd.banconnector.api.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Balance implements Serializable {

    private Long trackingNumber = null;
    private String bankTrackingNumber = null;
    private String accountReference = null;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ssXXX", timezone = "GMT-03:00")
    private Date processTimestamp = null;
    private String currencyCode = null;
    private BigDecimal amount = null;
    private String comments = null;

    public Balance() {

    }

    /**
     * Número de seguimiento
     **/

    @JsonProperty("trackingNumber")
    @NotNull
    public Long getTrackingNumber() {
        return trackingNumber;
    }

    public void setTrackingNumber(Long trackingNumber) {
        this.trackingNumber = trackingNumber;
    }

    /**
     * Número de seguimiento del sistema interno del banco
     **/

    @JsonProperty("bankTrackingNumber")
    @Size(max = 10)
    public String getBankTrackingNumber() {
        return bankTrackingNumber;
    }

    public void setBankTrackingNumber(String bankTrackingNumber) {
        this.bankTrackingNumber = bankTrackingNumber;
    }

    /**
     * Número de cuenta
     **/

    @JsonProperty("accountReference")
    @NotNull
    @Size(max = 255)
    public String getAccountReference() {
        return accountReference;
    }

    public void setAccountReference(String accountReference) {
        this.accountReference = accountReference;
    }

    /**
     * Fecha y hora del saldo
     **/


    @JsonProperty("processTimestamp")
    @NotNull
    public Date getProcessTimestamp() {
        return processTimestamp;
    }

    public void setProcessTimestamp(Date processTimestamp) {
        this.processTimestamp = processTimestamp;
    }

    /**
     * Código de moneda ISO 4217
     **/


    @JsonProperty("currencyCode")
    @Size(max = 3)
    public String getCurrencyCode() {
        return currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    /**
     * [15.2]Monto del saldo
     **/


    @JsonProperty("amount")
    @NotNull
    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    /**
     * Texto libre
     **/


    @JsonProperty("comments")
    @Size(max = 200)
    public String getComments() {
        return comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }


    @Override
    public String toString() {
        return "Balance ["
                + ((trackingNumber != null) ? "trackingNumber=" + trackingNumber + ", " : "")
                + ((bankTrackingNumber != null) ? "bankTrackingNumber=" + bankTrackingNumber + ", " : "")
                + ((accountReference != null) ? "accountReference=" + accountReference + ", " : "")
                + ((processTimestamp != null) ? "processTimestamp=" + processTimestamp + ", " : "")
                + ((currencyCode != null) ? "currencyCode=" + currencyCode + ", " : "")
                + ((amount != null) ? "amount=" + amount + ", " : "")
                + ((comments != null) ? "comments=" + comments : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Balance balance = (Balance) o;

        if (trackingNumber != null ? !trackingNumber.equals(balance.trackingNumber) : balance.trackingNumber != null) return false;
        if (bankTrackingNumber != null ? !bankTrackingNumber.equals(balance.bankTrackingNumber) : balance.bankTrackingNumber != null) return false;
        if (accountReference != null ? !accountReference.equals(balance.accountReference) : balance.accountReference != null) return false;
        if (processTimestamp != null ? !processTimestamp.equals(balance.processTimestamp) : balance.processTimestamp != null) return false;
        if (currencyCode != null ? !currencyCode.equals(balance.currencyCode) : balance.currencyCode != null) return false;
        if (amount != null ? !amount.equals(balance.amount) : balance.amount != null) return false;
        return comments != null ? comments.equals(balance.comments) : balance.comments == null;
    }

    @Override
    public int hashCode() {
        int result = trackingNumber != null ? trackingNumber.hashCode() : 0;
        result = 31 * result + (bankTrackingNumber != null ? bankTrackingNumber.hashCode() : 0);
        result = 31 * result + (accountReference != null ? accountReference.hashCode() : 0);
        result = 31 * result + (processTimestamp != null ? processTimestamp.hashCode() : 0);
        result = 31 * result + (currencyCode != null ? currencyCode.hashCode() : 0);
        result = 31 * result + (amount != null ? amount.hashCode() : 0);
        result = 31 * result + (comments != null ? comments.hashCode() : 0);
        return result;
    }
}

