package ar.com.sdd.banconnector.api.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class LoadTestSet implements Serializable {

    private Integer itemSize = null;
    private Integer itemQuantity = null;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ssXXX", timezone = "GMT-03:00")
    private Date timestamp = null;
    private List<LoadTestItem> loadTestItems = new ArrayList<LoadTestItem>();

    public LoadTestSet() {

    }

    public void addItem(LoadTestItem item) {
        loadTestItems.add(item);
    }

    /**
     * Tamaño de cada item en bytes
     **/


    @JsonProperty("itemSize")
    public Integer getItemSize() {
        return itemSize;
    }

    public void setItemSize(Integer itemSize) {
        this.itemSize = itemSize;
    }

    /**
     * Cantidad de items devueltos
     **/


    @JsonProperty("itemQuantity")
    public Integer getItemQuantity() {
        return itemQuantity;
    }

    public void setItemQuantity(Integer itemQuantity) {
        this.itemQuantity = itemQuantity;
    }

    /**
     * Fecha y hora del envío
     **/


    @JsonProperty("timestamp")
    public Date getTimestamp() {
        return timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    /**
     * Lista de items
     **/


    @JsonProperty("loadTestItems")
    public List<LoadTestItem> getLoadTestItems() {
        return loadTestItems;
    }

    public void setLoadTestItems(List<LoadTestItem> loadTestItems) {
        this.loadTestItems = loadTestItems;
    }


    @Override
    public String toString() {
        return "LoadTestSet ["
                + ((itemSize != null) ? "itemSize=" + itemSize + ", " : "")
                + ((itemQuantity != null) ? "itemQuantity=" + itemQuantity + ", " : "")
                + ((timestamp != null) ? "timestamp=" + timestamp + ", " : "")
                + ((loadTestItems != null) ? "loadTestItems=" + Arrays.toString(loadTestItems.toArray()) : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        LoadTestSet that = (LoadTestSet) o;

        if (itemSize != null ? !itemSize.equals(that.itemSize) : that.itemSize != null) return false;
        if (itemQuantity != null ? !itemQuantity.equals(that.itemQuantity) : that.itemQuantity != null) return false;
        if (timestamp != null ? !timestamp.equals(that.timestamp) : that.timestamp != null) return false;
        return loadTestItems != null ? loadTestItems.equals(that.loadTestItems) : that.loadTestItems == null;
    }

    @Override
    public int hashCode() {
        int result = itemSize != null ? itemSize.hashCode() : 0;
        result = 31 * result + (itemQuantity != null ? itemQuantity.hashCode() : 0);
        result = 31 * result + (timestamp != null ? timestamp.hashCode() : 0);
        result = 31 * result + (loadTestItems != null ? loadTestItems.hashCode() : 0);
        return result;
    }

}

