package ar.com.sdd.banconnector.api.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class StatementSet implements Serializable {

    private Long trackingNumber = null;
    private String bankTrackingNumber = null;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ssXXX", timezone = "GMT-03:00")
    private Date processTimestamp = null;
    private List<Statement> statements = new ArrayList<Statement>();

    public StatementSet() {

    }

    /**
     * Número de seguimiento
     **/


    @JsonProperty("trackingNumber")
    @NotNull
    public Long getTrackingNumber() {
        return trackingNumber;
    }

    public void setTrackingNumber(Long trackingNumber) {
        this.trackingNumber = trackingNumber;
    }

    /**
     * Número de seguimiento del sistema interno del banco
     **/


    @JsonProperty("bankTrackingNumber")
    @Size(max = 10)
    public String getBankTrackingNumber() {
        return bankTrackingNumber;
    }

    public void setBankTrackingNumber(String bankTrackingNumber) {
        this.bankTrackingNumber = bankTrackingNumber;
    }

    /**
     * Fecha y hora los movimientos
     **/


    @JsonProperty("processTimestamp")
    @NotNull
    public Date getProcessTimestamp() {
        return processTimestamp;
    }

    public void setProcessTimestamp(Date processTimestamp) {
        this.processTimestamp = processTimestamp;
    }

    /**
     * Lista de movimientos
     **/


    @JsonProperty("statements")
    @NotNull
    public List<Statement> getStatements() {
        return statements;
    }

    public void setStatements(List<Statement> statements) {
        this.statements = statements;
    }

    @Override
    public String toString() {
        return "StatementSet ["
                + ((trackingNumber != null) ? "trackingNumber=" + trackingNumber + ", " : "")
                + ((bankTrackingNumber != null) ? "bankTrackingNumber=" + bankTrackingNumber + ", " : "")
                + ((processTimestamp != null) ? "processTimestamp=" + processTimestamp + ", " : "")
                + ((statements != null) ? "statements=" + Arrays.toString(statements.toArray()) : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        StatementSet that = (StatementSet) o;

        if (trackingNumber != null ? !trackingNumber.equals(that.trackingNumber) : that.trackingNumber != null) return false;
        if (bankTrackingNumber != null ? !bankTrackingNumber.equals(that.bankTrackingNumber) : that.bankTrackingNumber != null) return false;
        if (processTimestamp != null ? !processTimestamp.equals(that.processTimestamp) : that.processTimestamp != null) return false;
        return statements != null ? statements.equals(that.statements) : that.statements == null;
    }

    @Override
    public int hashCode() {
        int result = trackingNumber != null ? trackingNumber.hashCode() : 0;
        result = 31 * result + (bankTrackingNumber != null ? bankTrackingNumber.hashCode() : 0);
        result = 31 * result + (processTimestamp != null ? processTimestamp.hashCode() : 0);
        result = 31 * result + (statements != null ? statements.hashCode() : 0);
        return result;
    }
}

