package ar.com.sdd.banconnector.api.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.math.BigDecimal;
import java.util.Date;

@JsonIgnoreProperties(ignoreUnknown = true)
public class DebitInstructionReturn {


    /**
     * Tipo de documento * DI: Instrucción de débito
     */
    public enum TypeEnum {
        DI("DI");
        private String value;

        TypeEnum(String value) {
            this.value = value;
        }

        @Override
        @JsonValue
        public String toString() {
            return String.valueOf(value);
        }
    }

    /**
     * Estado de la instrucción * PENDING: la instrucción todavia no esta en un estado final. No es necesario precisar los estados intermedios. * REJECTED: la instrucción fue rechazado y va a permanecer en ese estado final. * PAID: la instrucción fue pagada. * REVERSED: la instrucción sufrió una reversa.
     */
    public enum StatusEnum {
        PENDING("PENDING"),

        REJECTED("REJECTED"),

        PAID("PAID"),

        REVERSED("REVERSED");
        private String value;

        StatusEnum(String value) {
            this.value = value;
        }

        @Override
        @JsonValue
        public String toString() {
            return String.valueOf(value);
        }
    }

    /**
     * Marca de débito/crédito * D: Instrucción de débito * C: Instrucción de crédito
     */
    public enum DebitCreditMarkEnum {
        D("D"),

        C("C"),

        R("R");

        private String value;

        DebitCreditMarkEnum(String value) {
            this.value = value;
        }

        @Override
        @JsonValue
        public String toString() {
            return String.valueOf(value);
        }
    }

    private TypeEnum type = null;
    private String legalReference = null;
    private String instructionNumber = null;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date issueDate = null;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date creditDate = null;
    private StatusEnum status = null;
    private String bankStatus = null;
    private String rejectionReason = null;
    private BigDecimal dueAmount = null;
    private DebitCreditMarkEnum debitCreditMark = null;
    private String currencyCode = null;
    private String comments = null;

    /**
     * Tipo de documento * DI: Instrucción de débito
     **/

    @JsonProperty("type")
    @NotNull
    public TypeEnum getType() {
        return type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    /**
     * Identificador de la instrucción
     **/

    @JsonProperty("legalReference")
    @NotNull
    @Size(max = 255)
    public String getLegalReference() {
        return legalReference;
    }

    public void setLegalReference(String legalReference) {
        this.legalReference = legalReference;
    }

    @JsonProperty("instructionNumber")
    @Size(max = 255)
    public String getInstructionNumber() {
        return instructionNumber;
    }

    public void setInstructionNumber(String instructionNumber) {
        this.instructionNumber = instructionNumber;
    }

    @JsonProperty("issueDate")
    @NotNull
    public Date getIssueDate() {
        return issueDate;
    }

    public void setIssueDate(Date issueDate) {
        this.issueDate = issueDate;
    }

    /**
     * Fecha de acreditación de la instrucción
     **/

    @JsonProperty("creditDate")
    @NotNull
    public Date getCreditDate() {
        return creditDate;
    }

    public void setCreditDate(Date creditDate) {
        this.creditDate = creditDate;
    }

    /**
     * Estado de la instrucción * PENDING: la instrucción todavia no esta en un estado final. No es necesario precisar los estados intermedios. * REJECTED: la instrucción fue rechazado y va a permanecer en ese estado final. * PAID: la instrucción fue pagada. * REVERSED: la instrucción sufrió una reversa.
     **/

    @JsonProperty("status")
    @NotNull
    public StatusEnum getStatus() {
        return status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    /**
     * Estado de la instrucción en el código interno de la entidad
     **/

    @JsonProperty("bankStatus")
    @Size(max = 50)
    public String getBankStatus() {
        return bankStatus;
    }

    public void setBankStatus(String bankStatus) {
        this.bankStatus = bankStatus;
    }

    /**
     * Motivo de rechazo
     **/

    @JsonProperty("rejectionReason")
    @Size(max = 50)
    public String getRejectionReason() {
        return rejectionReason;
    }

    public void setRejectionReason(String rejectionReason) {
        this.rejectionReason = rejectionReason;
    }

    /**
     * [15.2]Monto aplicado
     **/

    @JsonProperty("dueAmount")
    @NotNull
    public BigDecimal getDueAmount() {
        return dueAmount;
    }

    public void setDueAmount(BigDecimal dueAmount) {
        this.dueAmount = dueAmount;
    }

    /**
     * Marca de débito/crédito * D: Instrucción de débito * C: Instrucción de crédito
     **/

    @JsonProperty("debitCreditMark")
    public DebitCreditMarkEnum getDebitCreditMark() {
        return debitCreditMark;
    }

    public void setDebitCreditMark(DebitCreditMarkEnum debitCreditMark) {
        this.debitCreditMark = debitCreditMark;
    }

    /**
     * Código de moneda ISO 4217
     **/

    @JsonProperty("currencyCode")
    @Size(max = 3)
    public String getCurrencyCode() {
        return currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    /**
     * Texto libre
     **/

    @JsonProperty("comments")
    @Size(max = 200)
    public String getComments() {
        return comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    @Override
    public String toString() {
        return "DebitInstructionReturn ["
                + ((type != null) ? "type=" + type + ", " : "")
                + ((legalReference != null) ? "legalReference=" + legalReference + ", " : "")
                + ((instructionNumber != null) ? "instructionNumber=" + instructionNumber + ", " : "")
                + ((issueDate != null) ? "issueDate=" + issueDate + ", " : "")
                + ((creditDate != null) ? "creditDate=" + creditDate + ", " : "")
                + ((status != null) ? "status=" + status + ", " : "")
                + ((bankStatus != null) ? "bankStatus=" + bankStatus + ", " : "")
                + ((rejectionReason != null) ? "rejectionReason=" + rejectionReason + ", " : "")
                + ((dueAmount != null) ? "dueAmount=" + dueAmount + ", " : "")
                + ((debitCreditMark != null) ? "debitCreditMark=" + debitCreditMark + ", " : "")
                + ((currencyCode != null) ? "currencyCode=" + currencyCode + ", " : "")
                + ((comments != null) ? "comments=" + comments : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        DebitInstructionReturn that = (DebitInstructionReturn) o;

        if (type != that.type) return false;
        if (legalReference != null ? !legalReference.equals(that.legalReference) : that.legalReference != null) return false;
        if (instructionNumber != null ? !instructionNumber.equals(that.instructionNumber) : that.instructionNumber != null) return false;
        if (issueDate != null ? !issueDate.equals(that.issueDate) : that.issueDate != null) return false;
        if (creditDate != null ? !creditDate.equals(that.creditDate) : that.creditDate != null) return false;
        if (status != that.status) return false;
        if (bankStatus != null ? !bankStatus.equals(that.bankStatus) : that.bankStatus != null) return false;
        if (rejectionReason != null ? !rejectionReason.equals(that.rejectionReason) : that.rejectionReason != null) return false;
        if (dueAmount != null ? !dueAmount.equals(that.dueAmount) : that.dueAmount != null) return false;
        if (debitCreditMark != that.debitCreditMark) return false;
        if (currencyCode != null ? !currencyCode.equals(that.currencyCode) : that.currencyCode != null) return false;
        return comments != null ? comments.equals(that.comments) : that.comments == null;
    }

    @Override
    public int hashCode() {
        int result = type != null ? type.hashCode() : 0;
        result = 31 * result + (legalReference != null ? legalReference.hashCode() : 0);
        result = 31 * result + (instructionNumber != null ? instructionNumber.hashCode() : 0);
        result = 31 * result + (issueDate != null ? issueDate.hashCode() : 0);
        result = 31 * result + (creditDate != null ? creditDate.hashCode() : 0);
        result = 31 * result + (status != null ? status.hashCode() : 0);
        result = 31 * result + (bankStatus != null ? bankStatus.hashCode() : 0);
        result = 31 * result + (rejectionReason != null ? rejectionReason.hashCode() : 0);
        result = 31 * result + (dueAmount != null ? dueAmount.hashCode() : 0);
        result = 31 * result + (debitCreditMark != null ? debitCreditMark.hashCode() : 0);
        result = 31 * result + (currencyCode != null ? currencyCode.hashCode() : 0);
        result = 31 * result + (comments != null ? comments.hashCode() : 0);
        return result;
    }
}

