/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.banconnector.api;

import ar.com.sdd.banconnector.api.DebitsApiService;
import ar.com.sdd.banconnector.api.model.DebitInstructionReturnSet;
import ar.com.sdd.commons.rest.log.ServerFileLogged;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Path(value="/banconnector/v1_1/debits")
public class DebitsApi {
    @Inject
    DebitsApiService service;

    @GET
    @ServerFileLogged
    @Path(value="/owner/{ownerCuit}/agreement/{agreementCode}/debit-instruction-set")
    @Produces(value={"application/json; charset=utf-8"})
    public Response getDebitInstructionSet(@HeaderParam(value="Bearer") String bearer, @PathParam(value="ownerCuit") String ownerCuit, @PathParam(value="agreementCode") String agreementCode, @QueryParam(value="trackingNumber") Long trackingNumber, @QueryParam(value="offset") Integer offset, @QueryParam(value="limit") Integer limit, @Context SecurityContext securityContext) {
        return this.service.getDebitInstructionSet(bearer, ownerCuit, agreementCode, trackingNumber, offset, limit, securityContext);
    }

    @POST
    @ServerFileLogged
    @Path(value="/owner/{ownerCuit}/agreement/{agreementCode}/debit-instruction-return-set")
    @Consumes(value={"application/json"})
    public Response postDebitInstructionReturnSet(@HeaderParam(value="Bearer") String bearer, @PathParam(value="ownerCuit") String ownerCuit, @PathParam(value="agreementCode") String agreementCode, DebitInstructionReturnSet debitInstructionReturnSet, @Context SecurityContext securityContext) {
        return this.service.postDebitInstructionReturnSet(bearer, ownerCuit, agreementCode, debitInstructionReturnSet, securityContext);
    }
}

