package ar.com.sdd.banconnector.api;

import ar.com.sdd.banconnector.api.model.StatementSet;
import ar.com.sdd.commons.rest.log.ServerFileLogged;

import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Path("/banconnector/v1_1/accounts")
public class StatementsApi {

    @Inject
    StatementsApiService service;

    @POST
    @ServerFileLogged
    @Path("/owner/{ownerCuit}/statement-sets")
    @Consumes({"application/json"})
    public Response postStatementSet(@HeaderParam("Bearer") String bearer, @PathParam("ownerCuit") String ownerCuit, StatementSet statementSet, @Context SecurityContext securityContext) {
        return service.postStatementSet(bearer, ownerCuit, statementSet, securityContext);
    }
}
