package ar.com.sdd.banconnector.api.model;

import com.fasterxml.jackson.annotation.JsonValue;

public interface BanconnectorEnum {

    /**
     * Condición de IVA del pagador. Segun Tipos de Responsables AFIP
     */
    enum TaxCodeEnum {
        IVA_RI("IVA_RI"),

        IVA_RNI("IVA_RNI"),

        IVA_NR("IVA_NR"),

        IVA_EX("IVA_EX"),

        CON_FINAL("CON_FINAL"),

        RES_MONO("RES_MONO"),

        SUJ_NO_CAT("SUJ_NO_CAT"),

        PROV_EXT("PROV_EXT"),

        CLI_EXT("CLI_EXT"),

        IVA_LIB("IVA_LIB"),

        IVA_RI_AG_PER("IVA_RI_AG_PER"),

        PEQ_CONT_EV("PEQ_CONT_EV"),

        MON_SOC("MON_SOC"),

        PEQ_CONT_EV_SOC("PEQ_CONT_EV_SOC");
        private String value;

        TaxCodeEnum(String value) {
            this.value = value;
        }

        @Override
        @JsonValue
        public String toString() {
            return String.valueOf(value);
        }
    }

    /**
     * Condición de IIBB del pagador
     */
    enum TaxCode2Enum {
        EXE("EXE"),

        LOC("LOC"),

        MUL("MUL"),

        NOI("NOI");
        private String value;

        TaxCode2Enum(String value) {
            this.value = value;
        }

        @Override
        @JsonValue
        public String toString() {
            return String.valueOf(value);
        }
    }

    /**
     * Gets or Sets instructionCodes
     */
    enum InstructionCodesEnum {
        EFEC("EFEC"),
        CHEQ("CHEQ"),
        TRAN("TRAN"),
        CPD("CPD"), //360 dias
        CPD360("CPD360"), //360 dias tambien
        CPD330("CPD330"), //330 dias
        CPD300("CPD300"), //300 dias
        CPD270("CPD270"), //270 dias
        CPD240("CPD240"), //240 dias
        CPD210("CPD210"), //210 dias
        CPD180("CPD180"), //180 dias
        CPD150("CPD150"), //150 dias
        CPD120("CPD120"), //120 dias
        CPD090("CPD090"), //90 dias
        CPD060("CPD060"), //60 dias
        CPD040("CPD040"), //
        CPD035("CPD035"), //
        CPD030("CPD030"), //30 dias
        CPD025("CPD025"), //
        CPD020("CPD020"), //
        CPD015("CPD015"), //
        CPD010("CPD010"), //360 dias tambien
        CPD005("CPD005"), //360 dias tambien
        ECHEQ("ECHEQ");

        private final String value;

        InstructionCodesEnum(String value) {
            this.value = value;
        }

        @Override
        @JsonValue
        public String toString() {
            return String.valueOf(value);
        }

        public static InstructionCodesEnum getCodeFor(int days) {
            if (days<=  1) return CHEQ;
            if (days<=  5) return CPD005;
            if (days<= 10) return CPD010;
            if (days<= 15) return CPD015;
            if (days<= 20) return CPD020;
            if (days<= 25) return CPD025;
            if (days<= 30) return CPD030;
            if (days<= 35) return CPD035;
            if (days<= 40) return CPD040;
            if (days<= 60) return CPD060;
            if (days<= 90) return CPD090;
            if (days<=120) return CPD120;
            if (days<=150) return CPD150;
            if (days<=180) return CPD180;
            if (days<=210) return CPD210;
            if (days<=240) return CPD240;
            if (days<=270) return CPD270;
            if (days<=330) return CPD300;
            if (days<=360) return CPD360;
            return CPD360;
        }
    }

    /**
     * Indica si el envío debe ser considerado como un FULL-REFRESH, o INCREMENTAL
     */
    enum PublicationModeEnum {
        FULLREFRESH("FULLREFRESH"),

        INCREMENTAL("INCREMENTAL");
        private String value;

        PublicationModeEnum(String value) {
            this.value = value;
        }

        @Override
        @JsonValue
        public String toString() {
            return String.valueOf(value);
        }
    }

    /**
     * Estado de la publicación de este documento
     */
    enum StatusEnum {
        PENDING("PENDING"),

        PUBLISHED("PUBLISHED"),

        ERROR("ERROR");
        private String value;

        StatusEnum(String value) {
            this.value = value;
        }

        @Override
        @JsonValue
        public String toString() {
            return String.valueOf(value);
        }
    }

}
