package ar.com.sdd.banconnector.api;


import ar.com.sdd.commons.rest.log.ServerFileLogged;
import ar.com.sdd.commons.rest.model.OAuth2Credential;

import javax.inject.Inject;
import javax.ws.rs.*;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Path("/banconnector/v1_1/auth")
public class AuthApi {

    @Inject
    AuthApiService service;

    @POST
    @ServerFileLogged
    @Path("/owner/{ownerCuit}/token.oauth2")
    @Consumes({"application/json"})
    @Produces("application/json; charset=utf-8")
    public Response postTokenOauth2(@PathParam("ownerCuit") String ownerCuit, OAuth2Credential oauthCredentials, @Context SecurityContext securityContext) {
        return service.postTokenOauth2(ownerCuit, oauthCredentials, securityContext);
    }
}
