package ar.com.sdd.banconnector.api;

import ar.com.sdd.banconnector.api.model.CollectionSetStatus;
import ar.com.sdd.commons.rest.log.ServerFileLogged;

import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Path("/banconnector/v1_1/collections")
public class CollectionsApi {

    @Inject
    CollectionsApiService service;

    @GET
    @ServerFileLogged
    @Path("/owner/{ownerCuit}/agreement/{agreementCode}/collection-sets")
    @Produces("application/json; charset=utf-8")
    public Response getCollectionSet(@HeaderParam("Bearer") String bearer, @PathParam("ownerCuit") String ownerCuit, @PathParam("agreementCode") String agreementCode, @QueryParam("trackingNumber") Long trackingNumber, @QueryParam("payerReferenceType") String payerReferenceType, @QueryParam("payerReference") String payerReference, @QueryParam("offset") Integer offset, @QueryParam("limit") Integer limit, @Context SecurityContext securityContext) {
        return service.getCollectionSet(bearer, ownerCuit, agreementCode, trackingNumber, payerReferenceType, payerReference, offset, limit, securityContext);
    }


    @POST
    @ServerFileLogged
    @Path("/owner/{ownerCuit}/agreement/{agreementCode}/collection-sets/{referencedTrackingNumber}/status")
    @Consumes({"application/json"})
    public Response postCollectionSetStatus(@HeaderParam("Bearer") String bearer, @PathParam("ownerCuit") String ownerCuit, @PathParam("agreementCode") String agreementCode, @PathParam("referencedTrackingNumber") Long referencedTrackingNumber, CollectionSetStatus collectionSetStatus, @Context SecurityContext securityContext) {
        return service.postCollectionSetStatus(bearer, ownerCuit, agreementCode, referencedTrackingNumber, collectionSetStatus, securityContext);
    }
}
