package ar.com.sdd.banconnector.api;

import ar.com.sdd.commons.rest.log.ServerFileLogged;

import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Path("/banconnector/v1_1/tests")
public class TestsApi {

    @Inject
    TestsApiService service;

    @GET
    @ServerFileLogged
    @Path("/owner/{ownerCuit}/load-test-set")
    @Produces("application/json; charset=utf-8")
    public Response getLoadTestSet(@PathParam("ownerCuit") String ownerCuit, @QueryParam("itemSize") Integer itemSize, @QueryParam("itemQuantity") Integer itemQuantity, @QueryParam("offset") Integer offset, @QueryParam("limit") Integer limit, @Context SecurityContext securityContext) {
        return service.getLoadTestSet(ownerCuit, itemSize, itemQuantity, offset, limit, securityContext);
    }
}
