package ar.com.sdd.banconnector.api.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;

@JsonIgnoreProperties(ignoreUnknown=true)
public class CommandParameter implements Serializable {

    //Algunos parametros conocidos
    public static final String COMMANDPARAM_REFERENCED_TRACKING_NUMBER = "referencedTrackingNumber";
    public static final String COMMANDPARAM_PROCESS_DATE = "processDate";
    public static final String COMMANDPARAM_ACCOUNT_REFERENCE = "accountReference";

    private String name = null;
    private String value = null;

    public CommandParameter() {

    }

    public CommandParameter(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @JsonProperty("name")
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty("value")
    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return "CommandParameter ["
                + ((name != null) ? "name=" + name + ", " : "")
                + ((value != null) ? "value=" + value : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        CommandParameter that = (CommandParameter) o;

        if (name != null ? !name.equals(that.name) : that.name != null) return false;
        return value != null ? value.equals(that.value) : that.value == null;
    }

    @Override
    public int hashCode() {
        int result = name != null ? name.hashCode() : 0;
        result = 31 * result + (value != null ? value.hashCode() : 0);
        return result;
    }
}
