package ar.com.sdd.banconnector.api.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class CustomerSetStatus implements Serializable {


    private Long trackingNumber = null;
    private String ownerCuit = null;
    private String agreementCode = null;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date processDate = null;
    private BanconnectorEnum.StatusEnum status = BanconnectorEnum.StatusEnum.PENDING;
    private String statusDescription = null;
    private List<Customer> customerErrors = new ArrayList<Customer>();

    public CustomerSetStatus() {

    }

    /**
     * Número de seguimiento
     **/


    @JsonProperty("trackingNumber")
    @NotNull
    public Long getTrackingNumber() {
        return trackingNumber;
    }

    public void setTrackingNumber(Long trackingNumber) {
        this.trackingNumber = trackingNumber;
    }

    /**
     * CUIT del propietario de las cuentas (sin guiones ni espacios)
     **/


    @JsonProperty("ownerCuit")
    @NotNull
    @Size(max = 11)
    public String getOwnerCuit() {
        return ownerCuit;
    }

    public void setOwnerCuit(String ownerCuit) {
        this.ownerCuit = ownerCuit;
    }

    /**
     * Código de acuerdo
     **/


    @JsonProperty("agreementCode")
    @NotNull
    @Size(max = 50)
    public String getAgreementCode() {
        return agreementCode;
    }

    public void setAgreementCode(String agreementCode) {
        this.agreementCode = agreementCode;
    }

    /**
     * Fecha de la publicación
     **/


    @JsonProperty("processDate")
    @NotNull
    public Date getProcessDate() {
        return processDate;
    }

    public void setProcessDate(Date processDate) {
        this.processDate = processDate;
    }

    /**
     * Estado de la publicación
     **/


    @JsonProperty("status")
    @NotNull
    public BanconnectorEnum.StatusEnum getStatus() {
        return status;
    }

    public void setStatus(BanconnectorEnum.StatusEnum status) {
        this.status = status;
    }

    /**
     * Descripción más detallada del estado de ser necesaria
     **/


    @JsonProperty("statusDescription")
    @Size(max = 1000)
    public String getStatusDescription() {
        return statusDescription;
    }

    public void setStatusDescription(String statusDescription) {
        this.statusDescription = statusDescription;
    }

    /**
     * Lista de clientes con error
     **/


    @JsonProperty("customerErrors")
    public List<Customer> getCustomerErrors() {
        return customerErrors;
    }

    public void setCustomerErrors(List<Customer> customerErrors) {
        this.customerErrors = customerErrors;
    }

    @Override
    public String toString() {
        return "CustomerSetStatus ["
                + ((trackingNumber != null) ? "trackingNumber=" + trackingNumber + ", " : "")
                + ((ownerCuit != null) ? "ownerCuit=" + ownerCuit + ", " : "")
                + ((agreementCode != null) ? "agreementCode=" + agreementCode + ", " : "")
                + ((processDate != null) ? "processDate=" + processDate + ", " : "")
                + ((status != null) ? "status=" + status + ", " : "")
                + ((statusDescription != null) ? "statusDescription=" + statusDescription + ", " : "")
                + ((customerErrors != null) ? "customerErrors=" + Arrays.toString(customerErrors.toArray()) : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        CustomerSetStatus that = (CustomerSetStatus) o;

        if (trackingNumber != null ? !trackingNumber.equals(that.trackingNumber) : that.trackingNumber != null) return false;
        if (ownerCuit != null ? !ownerCuit.equals(that.ownerCuit) : that.ownerCuit != null) return false;
        if (agreementCode != null ? !agreementCode.equals(that.agreementCode) : that.agreementCode != null) return false;
        if (processDate != null ? !processDate.equals(that.processDate) : that.processDate != null) return false;
        if (status != that.status) return false;
        if (statusDescription != null ? !statusDescription.equals(that.statusDescription) : that.statusDescription != null) return false;
        return customerErrors != null ? customerErrors.equals(that.customerErrors) : that.customerErrors == null;
    }

    @Override
    public int hashCode() {
        int result = trackingNumber != null ? trackingNumber.hashCode() : 0;
        result = 31 * result + (ownerCuit != null ? ownerCuit.hashCode() : 0);
        result = 31 * result + (agreementCode != null ? agreementCode.hashCode() : 0);
        result = 31 * result + (processDate != null ? processDate.hashCode() : 0);
        result = 31 * result + (status != null ? status.hashCode() : 0);
        result = 31 * result + (statusDescription != null ? statusDescription.hashCode() : 0);
        result = 31 * result + (customerErrors != null ? customerErrors.hashCode() : 0);
        return result;
    }
}

