package ar.com.sdd.banconnector.api;

import ar.com.sdd.banconnector.api.model.AccountSet;
import ar.com.sdd.banconnector.api.model.StatementSet;
import ar.com.sdd.commons.rest.log.ServerFileLogged;

import javax.inject.Inject;
import javax.ws.rs.*;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Path("/banconnector/v1_1/accounts")
public class AccountsApi {

    @Inject
    AccountsApiService service;

    @POST
    @ServerFileLogged
    @Path("/owner/{ownerCuit}/account-sets")
    @Consumes({"application/json"})
    public Response postStatementSet(@HeaderParam("Bearer") String bearer, @PathParam("ownerCuit") String ownerCuit, AccountSet accountSet, @Context SecurityContext securityContext) {
        return service.postAccountSet(bearer, ownerCuit, accountSet, securityContext);
    }
}
