package ar.com.sdd.banconnector.api.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AccountSet implements Serializable {

    private Long trackingNumber = null;
    private String bankTrackingNumber = null;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date processDate = null;
    private List<Account> accounts = new ArrayList<Account>();

    public AccountSet() {

    }

    /**
     * Número de seguimiento
     **/


    @JsonProperty("trackingNumber")
    @NotNull
    public Long getTrackingNumber() {
        return trackingNumber;
    }

    public void setTrackingNumber(Long trackingNumber) {
        this.trackingNumber = trackingNumber;
    }

    /**
     * Número de seguimiento del sistema interno del banco
     **/


    @JsonProperty("bankTrackingNumber")
    @Size(max = 10)
    public String getBankTrackingNumber() {
        return bankTrackingNumber;
    }

    public void setBankTrackingNumber(String bankTrackingNumber) {
        this.bankTrackingNumber = bankTrackingNumber;
    }

    /**
     * Fecha y hora los movimientos
     **/


    @JsonProperty("processDate")
    @NotNull
    public Date getProcessDate() {
        return processDate;
    }

    public void setProcessDate(Date processDate) {
        this.processDate = processDate;
    }

    /**
     * Lista de cuentas
     **/


    @JsonProperty("accounts")
    @NotNull
    public List<Account> getAccounts() {
        return accounts;
    }

    public void setAccounts(List<Account> accounts) {
        this.accounts = accounts;
    }

    @Override
    public String toString() {
        return "StatementSet ["
                + ((trackingNumber != null) ? "trackingNumber=" + trackingNumber + ", " : "")
                + ((bankTrackingNumber != null) ? "bankTrackingNumber=" + bankTrackingNumber + ", " : "")
                + ((processDate != null) ? "processDate=" + processDate + ", " : "")
                + ((accounts != null) ? "statements=" + Arrays.toString(accounts.toArray()) : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        AccountSet that = (AccountSet) o;

        if (trackingNumber != null ? !trackingNumber.equals(that.trackingNumber) : that.trackingNumber != null) return false;
        if (bankTrackingNumber != null ? !bankTrackingNumber.equals(that.bankTrackingNumber) : that.bankTrackingNumber != null) return false;
        if (processDate != null ? !processDate.equals(that.processDate) : that.processDate != null) return false;
        return accounts != null ? accounts.equals(that.accounts) : that.accounts == null;
    }

    @Override
    public int hashCode() {
        int result = trackingNumber != null ? trackingNumber.hashCode() : 0;
        result = 31 * result + (bankTrackingNumber != null ? bankTrackingNumber.hashCode() : 0);
        result = 31 * result + (processDate != null ? processDate.hashCode() : 0);
        result = 31 * result + (accounts != null ? accounts.hashCode() : 0);
        return result;
    }
}

