package ar.com.sdd.banconnector.api.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class CollectionItem implements Serializable {

    /**
     * Tipo de documento *
     *   FC: Factura
     *   ND: Nota de débito
     *   BD,VS: Boleta de depósito. El caso VS lo pidio banco galicia porque BD no es un código válido de moneda ISO 4217
     *   AP: Anticipo (a ser informado cuando se paga un anticipo)
     */
    public enum TypeEnum {
        FC("FC"),
        ND("ND"),
        BD("BD"),VS("VS"),
        AP("AP");
        private String value;

        TypeEnum(String value) {
            this.value = value;
        }

        @Override
        @JsonValue
        public String toString() {
            return String.valueOf(value);
        }
    }

    private TypeEnum type = null;
    private String legalReference = null;
    private String ownerReference = null;
    private PayerReference payerReference = null;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date issueDate = null;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date dueDate = null;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date dueDate2 = null;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date dueDate3 = null;
    private BigDecimal totalAmount = null;
    private BigDecimal dueAmount = null;
    private BigDecimal dueAmount2 = null;
    private BigDecimal dueAmount3 = null;
    private BigDecimal minimumAmount = null;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date discountDate = null;
    private BigDecimal discountAmount = null;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date penaltyDate = null;
    private BigDecimal penaltyAmount = null;
    private String currencyCode = null;
    private List<BanconnectorEnum.InstructionCodesEnum> instructionCodes = new ArrayList<>();
    private String comments = null;
    private String payerName = null;
    private String payerCuit = null;
    private String payerConcept = null;
    private String payerAddress = null;
    private String payerCity = null;
    private String payerState = null;
    private String payerZipCode = null;
    private String payerEmail = null;
    private BanconnectorEnum.TaxCodeEnum payerTaxCode = null;
    private BanconnectorEnum.TaxCode2Enum payerTaxCode2 = null;
    private CollectionItemStatus collectionItemStatus = null;

    public CollectionItem() {

    }

    /**
     * Tipo de documento * FC: Factura * ND: Nota de débito * BD: Boleta de depósito * AP: Anticipo (a ser informado cuando se paga un anticipo)
     **/
    @JsonProperty("type")
    public TypeEnum getType() {
        return type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }


    /**
     * Identificador legal del documento
     **/
    @JsonProperty("legalReference")
    @NotNull
    @Size(max = 255)
    public String getLegalReference() {
        return legalReference;
    }

    public void setLegalReference(String legalReference) {
        this.legalReference = legalReference;
    }

    /**
     * Identificador del documento dentro de la compañía (id interno de documento)
     **/


    @JsonProperty("ownerReference")
    @Size(max = 255)
    public String getOwnerReference() {
        return ownerReference;
    }

    public void setOwnerReference(String ownerReference) {
        this.ownerReference = ownerReference;
    }

    /**
     **/


    @JsonProperty("payerReference")
    @NotNull
    public PayerReference getPayerReference() {
        return payerReference;
    }

    public void setPayerReference(PayerReference payerReference) {
        this.payerReference = payerReference;
    }

    /**
     * Fecha de emisión del documento
     **/


    @JsonProperty("issueDate")
    public Date getIssueDate() {
        return issueDate;
    }

    public void setIssueDate(Date issueDate) {
        this.issueDate = issueDate;
    }

    /**
     * Primera fecha de vencimiento
     **/


    @JsonProperty("dueDate")
    public Date getDueDate() {
        return dueDate;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    /**
     * Segunda fecha de vencimiento
     **/


    @JsonProperty("dueDate2")
    public Date getDueDate2() {
        return dueDate2;
    }

    public void setDueDate2(Date dueDate2) {
        this.dueDate2 = dueDate2;
    }

    /**
     * Tercera fecha de vencimiento
     **/


    @JsonProperty("dueDate3")
    public Date getDueDate3() {
        return dueDate3;
    }

    public void setDueDate3(Date dueDate3) {
        this.dueDate3 = dueDate3;
    }

    /**
     * [15.2]Monto original
     **/


    @JsonProperty("totalAmount")
    public BigDecimal getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    /**
     * [15.2]Monto pendiente a la primera fecha de vencimiento
     **/


    @JsonProperty("dueAmount")
    @NotNull
    public BigDecimal getDueAmount() {
        return dueAmount;
    }

    public void setDueAmount(BigDecimal dueAmount) {
        this.dueAmount = dueAmount;
    }

    /**
     * [15.2]Monto pendiente a la segunda fecha de vencimiento
     **/


    @JsonProperty("dueAmount2")
    public BigDecimal getDueAmount2() {
        return dueAmount2;
    }

    public void setDueAmount2(BigDecimal dueAmount2) {
        this.dueAmount2 = dueAmount2;
    }

    /**
     * [15.2]Monto pendiente a la tercera fecha de vencimiento
     **/


    @JsonProperty("dueAmount3")
    public BigDecimal getDueAmount3() {
        return dueAmount3;
    }

    public void setDueAmount3(BigDecimal dueAmount3) {
        this.dueAmount3 = dueAmount3;
    }

    /**
     * [15.2]Monto mínimo a cancelar
     **/


    @JsonProperty("minimumAmount")
    public BigDecimal getMinimumAmount() {
        return minimumAmount;
    }

    public void setMinimumAmount(BigDecimal minimumAmount) {
        this.minimumAmount = minimumAmount;
    }

    /**
     * Fecha de pronto pago
     **/


    @JsonProperty("discountDate")
    public Date getDiscountDate() {
        return discountDate;
    }

    public void setDiscountDate(Date discountDate) {
        this.discountDate = discountDate;
    }

    /**
     * [15.2]Monto por pronto pago
     **/


    @JsonProperty("discountAmount")
    public BigDecimal getDiscountAmount() {
        return discountAmount;
    }

    public void setDiscountAmount(BigDecimal discountAmount) {
        this.discountAmount = discountAmount;
    }

    /**
     * Fecha hasta punitorios
     **/


    @JsonProperty("penaltyDate")
    public Date getPenaltyDate() {
        return penaltyDate;
    }

    public void setPenaltyDate(Date penaltyDate) {
        this.penaltyDate = penaltyDate;
    }

    /**
     * [15.2]Monto por punitorios
     **/


    @JsonProperty("penaltyAmount")
    public BigDecimal getPenaltyAmount() {
        return penaltyAmount;
    }

    public void setPenaltyAmount(BigDecimal penaltyAmount) {
        this.penaltyAmount = penaltyAmount;
    }

    /**
     * Código de moneda ISO 4217
     **/


    @JsonProperty("currencyCode")
    @Size(max = 3)
    public String getCurrencyCode() {
        return currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    /**
     * Formas de pago permitidas
     **/


    @JsonProperty("instructionCodes")
    public List<BanconnectorEnum.InstructionCodesEnum> getInstructionCodes() {
        return instructionCodes;
    }

    public void setInstructionCodes(List<BanconnectorEnum.InstructionCodesEnum> instructionCodes) {
        this.instructionCodes = instructionCodes;
    }

    /**
     * Texto libre
     **/


    @JsonProperty("comments")
    @Size(max = 200)
    public String getComments() {
        return comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    /**
     * Razón social del pagador
     **/


    @JsonProperty("payerName")
    @Size(max = 255)
    public String getPayerName() {
        return payerName;
    }

    public void setPayerName(String payerName) {
        this.payerName = payerName;
    }

    /**
     * CUIT del pagador
     **/


    @JsonProperty("payerCuit")
    @Size(max = 11)
    public String getPayerCuit() {
        return payerCuit;
    }

    public void setPayerCuit(String payerCuit) {
        this.payerCuit = payerCuit;
    }

    /**
     * Categorización del cliente dentro de la compañía
     **/


    @JsonProperty("payerConcept")
    @Size(max = 255)
    public String getPayerConcept() {
        return payerConcept;
    }

    public void setPayerConcept(String payerConcept) {
        this.payerConcept = payerConcept;
    }

    /**
     * Dirección del pagador
     **/


    @JsonProperty("payerAddress")
    @Size(max = 255)
    public String getPayerAddress() {
        return payerAddress;
    }

    public void setPayerAddress(String payerAddress) {
        this.payerAddress = payerAddress;
    }

    /**
     * Ciudad del pagador
     **/


    @JsonProperty("payerCity")
    @Size(max = 100)
    public String getPayerCity() {
        return payerCity;
    }

    public void setPayerCity(String payerCity) {
        this.payerCity = payerCity;
    }

    /**
     * Estado o provincia del pagador
     **/


    @JsonProperty("payerState")
    @Size(max = 100)
    public String getPayerState() {
        return payerState;
    }

    public void setPayerState(String payerState) {
        this.payerState = payerState;
    }

    /**
     * Código postal del pagador
     **/


    @JsonProperty("payerZipCode")
    @Size(max = 100)
    public String getPayerZipCode() {
        return payerZipCode;
    }

    public void setPayerZipCode(String payerZipCode) {
        this.payerZipCode = payerZipCode;
    }

    /**
     * Correo electrónico del pagador
     **/


    @JsonProperty("payerEmail")
    @Size(max = 150)
    public String getPayerEmail() {
        return payerEmail;
    }

    public void setPayerEmail(String payerEmail) {
        this.payerEmail = payerEmail;
    }

    /**
     * Condición de IVA del pagador. Segun Tipos de Responsables AFIP
     **/


    @JsonProperty("payerTaxCode")
    public BanconnectorEnum.TaxCodeEnum getPayerTaxCode() {
        return payerTaxCode;
    }

    public void setPayerTaxCode(BanconnectorEnum.TaxCodeEnum payerTaxCode) {
        this.payerTaxCode = payerTaxCode;
    }

    /**
     * Condición de IIBB del pagador
     **/


    @JsonProperty("payerTaxCode2")
    public BanconnectorEnum.TaxCode2Enum getPayerTaxCode2() {
        return payerTaxCode2;
    }

    public void setPayerTaxCode2(BanconnectorEnum.TaxCode2Enum payerTaxCode2) {
        this.payerTaxCode2 = payerTaxCode2;
    }

    /**
     **/


    @JsonProperty("collectionItemStatus")
    public CollectionItemStatus getCollectionItemStatus() {
        return collectionItemStatus;
    }

    public void setCollectionItemStatus(CollectionItemStatus collectionItemStatus) {
        this.collectionItemStatus = collectionItemStatus;
    }

    @Override
    public String toString() {
        return "CollectionItem ["
                + ((type != null) ? "type=" + type + ", " : "")
                + ((legalReference != null) ? "legalReference=" + legalReference + ", " : "")
                + ((ownerReference != null) ? "ownerReference=" + ownerReference + ", " : "")
                + ((payerReference != null) ? "payerReference=" + payerReference + ", " : "")
                + ((issueDate != null) ? "issueDate=" + issueDate + ", " : "")
                + ((dueDate != null) ? "dueDate=" + dueDate + ", " : "")
                + ((dueDate2 != null) ? "dueDate2=" + dueDate2 + ", " : "")
                + ((dueDate3 != null) ? "dueDate3=" + dueDate3 + ", " : "")
                + ((totalAmount != null) ? "totalAmount=" + totalAmount + ", " : "")
                + ((dueAmount != null) ? "dueAmount=" + dueAmount + ", " : "")
                + ((dueAmount2 != null) ? "dueAmount2=" + dueAmount2 + ", " : "")
                + ((dueAmount3 != null) ? "dueAmount3=" + dueAmount3 + ", " : "")
                + ((minimumAmount != null) ? "minimumAmount=" + minimumAmount + ", " : "")
                + ((discountDate != null) ? "discountDate=" + discountDate + ", " : "")
                + ((discountAmount != null) ? "discountAmount=" + discountAmount + ", " : "")
                + ((penaltyDate != null) ? "penaltyDate=" + penaltyDate + ", " : "")
                + ((penaltyAmount != null) ? "penaltyAmount=" + penaltyAmount + ", " : "")
                + ((currencyCode != null) ? "currencyCode=" + currencyCode + ", " : "")
                + ((instructionCodes != null) ? "instructionCodes=" + Arrays.toString(instructionCodes.toArray()) + ", " : "")
                + ((comments != null) ? "comments=" + comments + ", " : "")
                + ((payerName != null) ? "payerName=" + payerName + ", " : "")
                + ((payerCuit != null) ? "payerCuit=" + payerCuit + ", " : "")
                + ((payerConcept != null) ? "payerConcept=" + payerConcept + ", " : "")
                + ((payerAddress != null) ? "payerAddress=" + payerAddress + ", " : "")
                + ((payerCity != null) ? "payerCity=" + payerCity + ", " : "")
                + ((payerState != null) ? "payerState=" + payerState + ", " : "")
                + ((payerZipCode != null) ? "payerZipCode=" + payerZipCode + ", " : "")
                + ((payerEmail != null) ? "payerEmail=" + payerEmail + ", " : "")
                + ((payerTaxCode != null) ? "payerTaxCode=" + payerTaxCode + ", " : "")
                + ((payerTaxCode2 != null) ? "payerTaxCode2=" + payerTaxCode2 + ", " : "")
                + ((collectionItemStatus != null) ? "collectionItemStatus=" + collectionItemStatus : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        CollectionItem that = (CollectionItem) o;

        if (type != that.type) return false;
        if (legalReference != null ? !legalReference.equals(that.legalReference) : that.legalReference != null) return false;
        if (ownerReference != null ? !ownerReference.equals(that.ownerReference) : that.ownerReference != null) return false;
        if (payerReference != null ? !payerReference.equals(that.payerReference) : that.payerReference != null) return false;
        if (issueDate != null ? !issueDate.equals(that.issueDate) : that.issueDate != null) return false;
        if (dueDate != null ? !dueDate.equals(that.dueDate) : that.dueDate != null) return false;
        if (dueDate2 != null ? !dueDate2.equals(that.dueDate2) : that.dueDate2 != null) return false;
        if (dueDate3 != null ? !dueDate3.equals(that.dueDate3) : that.dueDate3 != null) return false;
        if (totalAmount != null ? !totalAmount.equals(that.totalAmount) : that.totalAmount != null) return false;
        if (dueAmount != null ? !dueAmount.equals(that.dueAmount) : that.dueAmount != null) return false;
        if (dueAmount2 != null ? !dueAmount2.equals(that.dueAmount2) : that.dueAmount2 != null) return false;
        if (dueAmount3 != null ? !dueAmount3.equals(that.dueAmount3) : that.dueAmount3 != null) return false;
        if (minimumAmount != null ? !minimumAmount.equals(that.minimumAmount) : that.minimumAmount != null) return false;
        if (discountDate != null ? !discountDate.equals(that.discountDate) : that.discountDate != null) return false;
        if (discountAmount != null ? !discountAmount.equals(that.discountAmount) : that.discountAmount != null) return false;
        if (penaltyDate != null ? !penaltyDate.equals(that.penaltyDate) : that.penaltyDate != null) return false;
        if (penaltyAmount != null ? !penaltyAmount.equals(that.penaltyAmount) : that.penaltyAmount != null) return false;
        if (currencyCode != null ? !currencyCode.equals(that.currencyCode) : that.currencyCode != null) return false;
        if (instructionCodes != null ? !instructionCodes.equals(that.instructionCodes) : that.instructionCodes != null) return false;
        if (comments != null ? !comments.equals(that.comments) : that.comments != null) return false;
        if (payerName != null ? !payerName.equals(that.payerName) : that.payerName != null) return false;
        if (payerCuit != null ? !payerCuit.equals(that.payerCuit) : that.payerCuit != null) return false;
        if (payerConcept != null ? !payerConcept.equals(that.payerConcept) : that.payerConcept != null) return false;
        if (payerAddress != null ? !payerAddress.equals(that.payerAddress) : that.payerAddress != null) return false;
        if (payerCity != null ? !payerCity.equals(that.payerCity) : that.payerCity != null) return false;
        if (payerState != null ? !payerState.equals(that.payerState) : that.payerState != null) return false;
        if (payerZipCode != null ? !payerZipCode.equals(that.payerZipCode) : that.payerZipCode != null) return false;
        if (payerEmail != null ? !payerEmail.equals(that.payerEmail) : that.payerEmail != null) return false;
        if (payerTaxCode != that.payerTaxCode) return false;
        if (payerTaxCode2 != that.payerTaxCode2) return false;
        return collectionItemStatus != null ? collectionItemStatus.equals(that.collectionItemStatus) : that.collectionItemStatus == null;
    }

    @Override
    public int hashCode() {
        int result = type != null ? type.hashCode() : 0;
        result = 31 * result + (legalReference != null ? legalReference.hashCode() : 0);
        result = 31 * result + (ownerReference != null ? ownerReference.hashCode() : 0);
        result = 31 * result + (payerReference != null ? payerReference.hashCode() : 0);
        result = 31 * result + (issueDate != null ? issueDate.hashCode() : 0);
        result = 31 * result + (dueDate != null ? dueDate.hashCode() : 0);
        result = 31 * result + (dueDate2 != null ? dueDate2.hashCode() : 0);
        result = 31 * result + (dueDate3 != null ? dueDate3.hashCode() : 0);
        result = 31 * result + (totalAmount != null ? totalAmount.hashCode() : 0);
        result = 31 * result + (dueAmount != null ? dueAmount.hashCode() : 0);
        result = 31 * result + (dueAmount2 != null ? dueAmount2.hashCode() : 0);
        result = 31 * result + (dueAmount3 != null ? dueAmount3.hashCode() : 0);
        result = 31 * result + (minimumAmount != null ? minimumAmount.hashCode() : 0);
        result = 31 * result + (discountDate != null ? discountDate.hashCode() : 0);
        result = 31 * result + (discountAmount != null ? discountAmount.hashCode() : 0);
        result = 31 * result + (penaltyDate != null ? penaltyDate.hashCode() : 0);
        result = 31 * result + (penaltyAmount != null ? penaltyAmount.hashCode() : 0);
        result = 31 * result + (currencyCode != null ? currencyCode.hashCode() : 0);
        result = 31 * result + (instructionCodes != null ? instructionCodes.hashCode() : 0);
        result = 31 * result + (comments != null ? comments.hashCode() : 0);
        result = 31 * result + (payerName != null ? payerName.hashCode() : 0);
        result = 31 * result + (payerCuit != null ? payerCuit.hashCode() : 0);
        result = 31 * result + (payerConcept != null ? payerConcept.hashCode() : 0);
        result = 31 * result + (payerAddress != null ? payerAddress.hashCode() : 0);
        result = 31 * result + (payerCity != null ? payerCity.hashCode() : 0);
        result = 31 * result + (payerState != null ? payerState.hashCode() : 0);
        result = 31 * result + (payerZipCode != null ? payerZipCode.hashCode() : 0);
        result = 31 * result + (payerEmail != null ? payerEmail.hashCode() : 0);
        result = 31 * result + (payerTaxCode != null ? payerTaxCode.hashCode() : 0);
        result = 31 * result + (payerTaxCode2 != null ? payerTaxCode2.hashCode() : 0);
        result = 31 * result + (collectionItemStatus != null ? collectionItemStatus.hashCode() : 0);
        return result;
    }
}

