package ar.com.sdd.banconnector.api.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Command implements Serializable {

    private Long trackingNumber = null;
    private String ownerCuit = null;
    private String agreementCode = null;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date processDate = null;
    private Long totalCount = null;
    private String operationName = null;
    private List<CommandParameter> parameters = new ArrayList<>();

    public Command() {

    }

    @JsonProperty("trackingNumber")
    public Long getTrackingNumber() {
        return trackingNumber;
    }

    public void setTrackingNumber(Long trackingNumber) {
        this.trackingNumber = trackingNumber;
    }

    @JsonProperty("ownerCuit")
    @Size(max = 11)
    public String getOwnerCuit() {
        return ownerCuit;
    }

    public void setOwnerCuit(String ownerCuit) {
        this.ownerCuit = ownerCuit;
    }

    @JsonProperty("agreementCode")
    @Size(max = 50)
    public String getAgreementCode() {
        return agreementCode;
    }

    public void setAgreementCode(String agreementCode) {
        this.agreementCode = agreementCode;
    }

    @JsonProperty("processDate")
    public Date getProcessDate() {
        return processDate;
    }

    public void setProcessDate(Date processDate) {
        this.processDate = processDate;
    }

    @JsonProperty("totalCount")
    public Long getTotalCount() {
        return totalCount;
    }

    public void setTotalCount(Long totalCount) {
        this.totalCount = totalCount;
    }

    @JsonProperty("operationName")
    public String getOperationName() {
        return operationName;
    }

    public void setOperationName(String operationName) {
        this.operationName = operationName;
    }

    @JsonProperty("parameters")
    public List<CommandParameter> getParameters() {
        return parameters;
    }

    public void setParameters(List<CommandParameter> parameters) {
        this.parameters = parameters;
    }

    @Override
    public String toString() {
        return "Command ["
                + ((trackingNumber != null) ? "trackingNumber=" + trackingNumber + ", " : "")
                + ((ownerCuit != null) ? "ownerCuit=" + ownerCuit + ", " : "")
                + ((agreementCode != null) ? "agreementCode=" + agreementCode + ", " : "")
                + ((processDate != null) ? "processDate=" + processDate + ", " : "")
                + ((totalCount != null) ? "totalCount=" + totalCount + ", " : "")
                + ((operationName != null) ? "operationName=" + operationName + ", " : "")
                + ((parameters != null) ? "parameters=" + Arrays.toString(parameters.toArray()) : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Command command = (Command) o;

        if (trackingNumber != null ? !trackingNumber.equals(command.trackingNumber) : command.trackingNumber != null) return false;
        if (ownerCuit != null ? !ownerCuit.equals(command.ownerCuit) : command.ownerCuit != null) return false;
        if (agreementCode != null ? !agreementCode.equals(command.agreementCode) : command.agreementCode != null) return false;
        if (processDate != null ? !processDate.equals(command.processDate) : command.processDate != null) return false;
        if (totalCount != null ? !totalCount.equals(command.totalCount) : command.totalCount != null) return false;
        if (operationName != null ? !operationName.equals(command.operationName) : command.operationName != null) return false;
        return parameters != null ? parameters.equals(command.parameters) : command.parameters == null;
    }

    @Override
    public int hashCode() {
        int result = trackingNumber != null ? trackingNumber.hashCode() : 0;
        result = 31 * result + (ownerCuit != null ? ownerCuit.hashCode() : 0);
        result = 31 * result + (agreementCode != null ? agreementCode.hashCode() : 0);
        result = 31 * result + (processDate != null ? processDate.hashCode() : 0);
        result = 31 * result + (totalCount != null ? totalCount.hashCode() : 0);
        result = 31 * result + (operationName != null ? operationName.hashCode() : 0);
        result = 31 * result + (parameters != null ? parameters.hashCode() : 0);
        return result;
    }
}
