/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.banconnector.api.model;

import ar.com.sdd.banconnector.api.model.Account;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AccountSet
implements Serializable {
    private Long trackingNumber = null;
    private String bankTrackingNumber = null;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd", timezone="GMT-03:00")
    private Date processDate = null;
    private List<Account> accounts = new ArrayList<Account>();

    @JsonProperty(value="trackingNumber")
    @NotNull
    public Long getTrackingNumber() {
        return this.trackingNumber;
    }

    public void setTrackingNumber(Long trackingNumber) {
        this.trackingNumber = trackingNumber;
    }

    @JsonProperty(value="bankTrackingNumber")
    @Size(max=10)
    public @Size(max=10) String getBankTrackingNumber() {
        return this.bankTrackingNumber;
    }

    public void setBankTrackingNumber(String bankTrackingNumber) {
        this.bankTrackingNumber = bankTrackingNumber;
    }

    @JsonProperty(value="processDate")
    @NotNull
    public Date getProcessDate() {
        return this.processDate;
    }

    public void setProcessDate(Date processDate) {
        this.processDate = processDate;
    }

    @JsonProperty(value="accounts")
    @NotNull
    public List<Account> getAccounts() {
        return this.accounts;
    }

    public void setAccounts(List<Account> accounts) {
        this.accounts = accounts;
    }

    public String toString() {
        return "StatementSet [" + (String)(this.trackingNumber != null ? "trackingNumber=" + this.trackingNumber + ", " : "") + (String)(this.bankTrackingNumber != null ? "bankTrackingNumber=" + this.bankTrackingNumber + ", " : "") + (String)(this.processDate != null ? "processDate=" + this.processDate + ", " : "") + (String)(this.accounts != null ? "statements=" + Arrays.toString(this.accounts.toArray()) : "") + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountSet that = (AccountSet)o;
        if (this.trackingNumber != null ? !this.trackingNumber.equals(that.trackingNumber) : that.trackingNumber != null) {
            return false;
        }
        if (this.bankTrackingNumber != null ? !this.bankTrackingNumber.equals(that.bankTrackingNumber) : that.bankTrackingNumber != null) {
            return false;
        }
        if (this.processDate != null ? !this.processDate.equals(that.processDate) : that.processDate != null) {
            return false;
        }
        return this.accounts != null ? this.accounts.equals(that.accounts) : that.accounts == null;
    }

    public int hashCode() {
        int result = this.trackingNumber != null ? this.trackingNumber.hashCode() : 0;
        result = 31 * result + (this.bankTrackingNumber != null ? this.bankTrackingNumber.hashCode() : 0);
        result = 31 * result + (this.processDate != null ? this.processDate.hashCode() : 0);
        result = 31 * result + (this.accounts != null ? this.accounts.hashCode() : 0);
        return result;
    }
}

