/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.banconnector.api.model;

import com.fasterxml.jackson.annotation.JsonValue;

public interface BanconnectorEnum {

    public static enum StatusEnum {
        PENDING("PENDING"),
        PUBLISHED("PUBLISHED"),
        ERROR("ERROR");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum PublicationModeEnum {
        FULLREFRESH("FULLREFRESH"),
        INCREMENTAL("INCREMENTAL");

        private String value;

        private PublicationModeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum InstructionCodesEnum {
        EFEC("EFEC"),
        CHEQ("CHEQ"),
        TRAN("TRAN"),
        CPD("CPD"),
        CPD360("CPD360"),
        CPD330("CPD330"),
        CPD300("CPD300"),
        CPD270("CPD270"),
        CPD240("CPD240"),
        CPD210("CPD210"),
        CPD180("CPD180"),
        CPD150("CPD150"),
        CPD120("CPD120"),
        CPD090("CPD090"),
        CPD060("CPD060"),
        CPD040("CPD040"),
        CPD035("CPD035"),
        CPD030("CPD030"),
        CPD025("CPD025"),
        CPD020("CPD020"),
        CPD015("CPD015"),
        CPD010("CPD010"),
        CPD005("CPD005"),
        ECHEQ("ECHEQ"),
        CVU("CVU");

        private final String value;

        private InstructionCodesEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }

        public static InstructionCodesEnum getCodeFor(int days) {
            if (days <= 1) {
                return CHEQ;
            }
            if (days <= 5) {
                return CPD005;
            }
            if (days <= 10) {
                return CPD010;
            }
            if (days <= 15) {
                return CPD015;
            }
            if (days <= 20) {
                return CPD020;
            }
            if (days <= 25) {
                return CPD025;
            }
            if (days <= 30) {
                return CPD030;
            }
            if (days <= 35) {
                return CPD035;
            }
            if (days <= 40) {
                return CPD040;
            }
            if (days <= 60) {
                return CPD060;
            }
            if (days <= 90) {
                return CPD090;
            }
            if (days <= 120) {
                return CPD120;
            }
            if (days <= 150) {
                return CPD150;
            }
            if (days <= 180) {
                return CPD180;
            }
            if (days <= 210) {
                return CPD210;
            }
            if (days <= 240) {
                return CPD240;
            }
            if (days <= 270) {
                return CPD270;
            }
            if (days <= 330) {
                return CPD300;
            }
            if (days <= 360) {
                return CPD360;
            }
            return CPD360;
        }
    }

    public static enum TaxCode2Enum {
        EXE("EXE"),
        LOC("LOC"),
        MUL("MUL"),
        NOI("NOI");

        private String value;

        private TaxCode2Enum(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum TaxCodeEnum {
        IVA_RI("IVA_RI"),
        IVA_RNI("IVA_RNI"),
        IVA_NR("IVA_NR"),
        IVA_EX("IVA_EX"),
        CON_FINAL("CON_FINAL"),
        RES_MONO("RES_MONO"),
        SUJ_NO_CAT("SUJ_NO_CAT"),
        PROV_EXT("PROV_EXT"),
        CLI_EXT("CLI_EXT"),
        IVA_LIB("IVA_LIB"),
        IVA_RI_AG_PER("IVA_RI_AG_PER"),
        PEQ_CONT_EV("PEQ_CONT_EV"),
        MON_SOC("MON_SOC"),
        PEQ_CONT_EV_SOC("PEQ_CONT_EV_SOC");

        private String value;

        private TaxCodeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

