package ar.com.sdd.banconnector.api;

import ar.com.sdd.banconnector.api.model.DebitInstructionReturnSet;
import ar.com.sdd.commons.rest.log.ServerFileLogged;

import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Path("/banconnector/v1_1/debits")
public class DebitsApi {

    @Inject
    DebitsApiService service;

    @GET
    @ServerFileLogged
    @Path("/owner/{ownerCuit}/agreement/{agreementCode}/debit-instruction-set")
    @Produces("application/json; charset=utf-8")
    public Response getDebitInstructionSet(@HeaderParam("Bearer") String bearer, @PathParam("ownerCuit") String ownerCuit, @PathParam("agreementCode") String agreementCode, @QueryParam("trackingNumber") Long trackingNumber, @QueryParam("offset") Integer offset, @QueryParam("limit") Integer limit, @Context SecurityContext securityContext) {
        return service.getDebitInstructionSet(bearer, ownerCuit, agreementCode, trackingNumber, offset, limit, securityContext);
    }

    @POST
    @ServerFileLogged
    @Path("/owner/{ownerCuit}/agreement/{agreementCode}/debit-instruction-return-set")
    @Consumes({"application/json"})
    public Response postDebitInstructionReturnSet(@HeaderParam("Bearer") String bearer, @PathParam("ownerCuit") String ownerCuit, @PathParam("agreementCode") String agreementCode, DebitInstructionReturnSet debitInstructionReturnSet, @Context SecurityContext securityContext) {
        return service.postDebitInstructionReturnSet(bearer, ownerCuit, agreementCode, debitInstructionReturnSet, securityContext);
    }

}
