package ar.com.sdd.banconnector.api.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Account implements Serializable {
    private String ownerReference = null;
    private String unifiedBankReference = null;  //CBU o CVU
    private String alias = null; //alias, opcional
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date issueDate = null;
    private PayerReference payerReference = null;
    private DocumentReference documentReference = null;
    private String currencyCode = null;

    public String getOwnerReference() {
        return ownerReference;
    }

    public void setOwnerReference(String ownerReference) {
        this.ownerReference = ownerReference;
    }

    public String getUnifiedBankReference() {
        return unifiedBankReference;
    }

    public void setUnifiedBankReference(String unifiedBankReference) {
        this.unifiedBankReference = unifiedBankReference;
    }
    public String getAlias() {        return alias;}
    public void  setAlias(String alias) {  this.alias=alias;}

    public Date getIssueDate() {
        return issueDate;
    }

    public void setIssueDate(Date issueDate) {
        this.issueDate = issueDate;
    }

    public PayerReference getPayerReference() {
        return payerReference;
    }

    public void setPayerReference(PayerReference payerReference) {
        this.payerReference = payerReference;
    }

    public DocumentReference getDocumentReference() {
        return documentReference;
    }

    public void setDocumentReference(DocumentReference documentReference) {
        this.documentReference = documentReference;
    }

    @JsonProperty("currencyCode")
    @Size(max = 3)
    public String getCurrencyCode() {
        return currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Account account = (Account) o;
        return Objects.equals(ownerReference, account.ownerReference) && Objects.equals(unifiedBankReference, account.unifiedBankReference) && Objects.equals(issueDate, account.issueDate) && Objects.equals(payerReference, account.payerReference) && Objects.equals(documentReference, account.documentReference) && Objects.equals(currencyCode, account.currencyCode);
    }

    @Override
    public int hashCode() {
        return Objects.hash(ownerReference, unifiedBankReference, alias, issueDate, payerReference, documentReference,currencyCode);
    }

    @Override
    public String toString() {
        return "Account [" +
                ((ownerReference != null) ? "ownerReference='" + ownerReference + "', " : "") +
                ((alias != null) ? "alias='" + alias + "', " : "") +
                ((unifiedBankReference != null) ? "unifiedBankReference='" + unifiedBankReference + "', " : "") +
                ((issueDate != null) ? "issueDate=" + issueDate + ", " : "") +
                ((payerReference != null) ? "payerReference=" + payerReference + ", " : "") +
                ((documentReference != null) ? "documentReference=" + documentReference + ", " : "") +
                ((currencyCode != null) ? "currencyCode=" + currencyCode + ", " : "") +
                "]";
    }
}
