package ar.com.sdd.banconnector.api.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;

@JsonIgnoreProperties(ignoreUnknown=true)
public class DocumentReference implements Serializable {

    /**
     * Tipo de documento * FC: Factura * ND: Nota de débito * BD: Boleta de depósito * AP: Anticipo (a ser informado cuando se paga un anticipo)
     */
    public enum TypeEnum {
        FC("FC"),

        ND("ND"),

        BD("BD"),

        AP("AP");
        private String value;

        TypeEnum(String value) {
            this.value = value;
        }

        @Override
        @JsonValue
        public String toString() {
            return String.valueOf(value);
        }
    }

    private CollectionItem.TypeEnum type = null;
    private String legalReference = null;
    private String installment  = null;

    public CollectionItem.TypeEnum getType() {
        return type;
    }

    public void setType(CollectionItem.TypeEnum type) {
        this.type = type;
    }

    public String getLegalReference() {
        return legalReference;
    }

    public void setLegalReference(String legalReference) {
        this.legalReference = legalReference;
    }

    public String getInstallment() {
        return installment;
    }

    public void setInstallment(String installment) {
        this.installment = installment;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        DocumentReference that = (DocumentReference) o;
        return type == that.type && Objects.equals(legalReference, that.legalReference) && Objects.equals(installment, that.installment);
    }

    @Override
    public int hashCode() {
        return Objects.hash(type, legalReference, installment);
    }

    @Override
    public String toString() {
        return "DocumentReference [" +
                ((type != null) ? "type=" + type + ", " : "") +
                ((legalReference != null) ? "legalReference='" + legalReference + "', " : "") +
                ((installment != null) ? "installment='" + installment + "', " : "") +
                "]";
    }
}

