package ar.com.sdd.banconnector.api.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PayerReference implements Serializable {


    /**
     * Tipo de identificación del pagador
     * No puedo incrementar/modificar estas sin coordinar con cada contraparte que las use
     * Si agregamos alguna deberiamos cambiar la versio de la API para que sea mas claro
     */
    public enum TypeEnum {
        ID("ID"),

        DNRP("DNRP"),

        DNI("DNI"),

        CI("CI"),

        PAS("PAS"),

        LC("LC"),

        LE("LE"),

        CUIT("CUIT"),

        CLIE("CLIE"),
        ;

        private String value;

        TypeEnum(String value) {
            this.value = value;
        }

        @Override
        @JsonValue
        public String toString() {
            return String.valueOf(value);
        }
    }

    private TypeEnum type = TypeEnum.ID;
    private String reference = null;


    public PayerReference() {

    }

    /**
     * Tipo de identificación del pagador
     **/


    @JsonProperty("type")
    @NotNull
    public TypeEnum getType() {
        return type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    /**
     * Identificación del pagador
     **/


    @JsonProperty("reference")
    @NotNull
    @Size(max = 50)
    public String getReference() {
        return reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    @Override
    public String toString() {
        return "PayerReference ["
                + ((type != null) ? "type=" + type + ", " : "")
                + ((reference != null) ? "reference=" + reference : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        PayerReference that = (PayerReference) o;

        if (type != that.type) return false;
        return reference != null ? reference.equals(that.reference) : that.reference == null;
    }

    @Override
    public int hashCode() {
        int result = type != null ? type.hashCode() : 0;
        result = 31 * result + (reference != null ? reference.hashCode() : 0);
        return result;
    }
}

