package ar.com.sdd.banconnector.api.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Payment implements Serializable {

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ssXXX", timezone = "GMT-03:00")
    private Date issueDateTime = null;
    private String accountReference = null;
    private String legalReference = null;
    private PayerReference payerReference = null;
    private String currencyCode = null;
    private BigDecimal totalAmount = null;
    private List<CollectionItem> collectionItems = new ArrayList<>();
    private List<PaymentInstrument> paymentInstruments = new ArrayList<>();

    public Payment() {

    }

    /**
     * Fecha y hora del pago
     **/
    @JsonProperty("issueDateTime")
    @NotNull
    public Date getIssueDateTime() {
        return issueDateTime;
    }

    public void setIssueDateTime(Date issueDateTime) {
        this.issueDateTime = issueDateTime;
    }

    /**
     * Número de cuenta recaudadora
     **/


    @JsonProperty("accountReference")
    @NotNull
    @Size(max = 255)
    public String getAccountReference() {
        return accountReference;
    }

    public void setAccountReference(String accountReference) {
        this.accountReference = accountReference;
    }

    /**
     * Identificación del pago. CAMPO CLAVE (con este campo se determina creación o actualización).
     **/


    @JsonProperty("legalReference")
    @NotNull
    @Size(max = 255)
    public String getLegalReference() {
        return legalReference;
    }

    public void setLegalReference(String legalReference) {
        this.legalReference = legalReference;
    }

    /**
     **/


    @JsonProperty("payerReference")
    @NotNull
    public PayerReference getPayerReference() {
        return payerReference;
    }

    public void setPayerReference(PayerReference payerReference) {
        this.payerReference = payerReference;
    }

    /**
     * Código de moneda ISO 4217 del pago
     **/


    @JsonProperty("currencyCode")
    @Size(max = 3)
    public String getCurrencyCode() {
        return currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    /**
     * [15.2]Monto total del pago
     **/


    @JsonProperty("totalAmount")
    @NotNull
    public BigDecimal getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    /**
     * Lista de documentos de documentos pagados
     **/


    @JsonProperty("collectionItems")
    public List<CollectionItem> getCollectionItems() {
        return collectionItems;
    }

    public void setCollectionItems(List<CollectionItem> collectionItems) {
        this.collectionItems = collectionItems;
    }

    /**
     * Lista de instrumentos que cancelan los documentos
     **/


    @JsonProperty("paymentInstruments")
    @NotNull
    public List<PaymentInstrument> getPaymentInstruments() {
        return paymentInstruments;
    }

    public void setPaymentInstruments(List<PaymentInstrument> paymentInstruments) {
        this.paymentInstruments = paymentInstruments;
    }


    @Override
    public String toString() {
        return "Payment ["
                + ((issueDateTime != null) ? "issueDateTime=" + issueDateTime + ", " : "")
                + ((accountReference != null) ? "accountReference=" + accountReference + ", " : "")
                + ((legalReference != null) ? "legalReference=" + legalReference + ", " : "")
                + ((payerReference != null) ? "payerReference=" + payerReference + ", " : "")
                + ((currencyCode != null) ? "currencyCode=" + currencyCode + ", " : "")
                + ((totalAmount != null) ? "totalAmount=" + totalAmount + ", " : "")
                + ((collectionItems != null) ? "collectionItems=" + Arrays.toString(collectionItems.toArray()) + ", " : "")
                + ((paymentInstruments != null) ? "paymentInstruments=" + Arrays.toString(paymentInstruments.toArray()) : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Payment payment = (Payment) o;

        if (issueDateTime != null ? !issueDateTime.equals(payment.issueDateTime) : payment.issueDateTime != null) return false;
        if (accountReference != null ? !accountReference.equals(payment.accountReference) : payment.accountReference != null) return false;
        if (legalReference != null ? !legalReference.equals(payment.legalReference) : payment.legalReference != null) return false;
        if (payerReference != null ? !payerReference.equals(payment.payerReference) : payment.payerReference != null) return false;
        if (currencyCode != null ? !currencyCode.equals(payment.currencyCode) : payment.currencyCode != null) return false;
        if (totalAmount != null ? !totalAmount.equals(payment.totalAmount) : payment.totalAmount != null) return false;
        if (collectionItems != null ? !collectionItems.equals(payment.collectionItems) : payment.collectionItems != null) return false;
        return paymentInstruments != null ? paymentInstruments.equals(payment.paymentInstruments) : payment.paymentInstruments == null;
    }

    @Override
    public int hashCode() {
        int result = issueDateTime != null ? issueDateTime.hashCode() : 0;
        result = 31 * result + (accountReference != null ? accountReference.hashCode() : 0);
        result = 31 * result + (legalReference != null ? legalReference.hashCode() : 0);
        result = 31 * result + (payerReference != null ? payerReference.hashCode() : 0);
        result = 31 * result + (currencyCode != null ? currencyCode.hashCode() : 0);
        result = 31 * result + (totalAmount != null ? totalAmount.hashCode() : 0);
        result = 31 * result + (collectionItems != null ? collectionItems.hashCode() : 0);
        result = 31 * result + (paymentInstruments != null ? paymentInstruments.hashCode() : 0);
        return result;
    }
}

