package ar.com.sdd.banconnector.api;

import ar.com.sdd.banconnector.api.model.PaymentInstrumentImageSet;
import ar.com.sdd.banconnector.api.model.PaymentSet;
import ar.com.sdd.commons.rest.log.ServerFileLogged;

import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Path("/payments")
public class PaymentsApi {

    @Inject
    PaymentsApiService service;

    @POST
    @ServerFileLogged
    @Path("/owner/{ownerCuit}/agreement/{agreementCode}/payment-instrument-image-sets")
    @Consumes({"application/json"})
    public Response postPaymentInstrumentImageSet(@HeaderParam("Bearer") String bearer, @PathParam("ownerCuit") String ownerCuit, @PathParam("agreementCode") String agreementCode, PaymentInstrumentImageSet paymentInstrumentImageSet, @Context SecurityContext securityContext) {
        return service.postPaymentInstrumentImageSet(bearer, ownerCuit, agreementCode, paymentInstrumentImageSet, securityContext);
    }

    @POST
    @ServerFileLogged
    @Path("/owner/{ownerCuit}/agreement/{agreementCode}/payment-sets")
    @Consumes({"application/json"})
    public Response postPaymentSet(@HeaderParam("Bearer") String bearer, @PathParam("ownerCuit") String ownerCuit, @PathParam("agreementCode") String agreementCode, PaymentSet paymentSet, @Context SecurityContext securityContext) {
        return service.postPaymentSet(bearer, ownerCuit, agreementCode, paymentSet, securityContext);
    }
}
