/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.banconnector.api.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Balance
implements Serializable {
    private Long trackingNumber = null;
    private String bankTrackingNumber = null;
    private String accountReference = null;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ssXXX", timezone="GMT-03:00")
    private Date processTimestamp = null;
    private String currencyCode = null;
    private BigDecimal amount = null;
    private String comments = null;

    @JsonProperty(value="trackingNumber")
    @NotNull
    public Long getTrackingNumber() {
        return this.trackingNumber;
    }

    public void setTrackingNumber(Long trackingNumber) {
        this.trackingNumber = trackingNumber;
    }

    @JsonProperty(value="bankTrackingNumber")
    @Size(max=10)
    public @Size(max=10) String getBankTrackingNumber() {
        return this.bankTrackingNumber;
    }

    public void setBankTrackingNumber(String bankTrackingNumber) {
        this.bankTrackingNumber = bankTrackingNumber;
    }

    @JsonProperty(value="accountReference")
    @NotNull
    @Size(max=255)
    public @NotNull @Size(max=255) String getAccountReference() {
        return this.accountReference;
    }

    public void setAccountReference(String accountReference) {
        this.accountReference = accountReference;
    }

    @JsonProperty(value="processTimestamp")
    @NotNull
    public Date getProcessTimestamp() {
        return this.processTimestamp;
    }

    public void setProcessTimestamp(Date processTimestamp) {
        this.processTimestamp = processTimestamp;
    }

    @JsonProperty(value="currencyCode")
    @Size(max=3)
    public @Size(max=3) String getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    @JsonProperty(value="amount")
    @NotNull
    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    @JsonProperty(value="comments")
    @Size(max=200)
    public @Size(max=200) String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public String toString() {
        return "Balance [" + (String)(this.trackingNumber != null ? "trackingNumber=" + this.trackingNumber + ", " : "") + (String)(this.bankTrackingNumber != null ? "bankTrackingNumber=" + this.bankTrackingNumber + ", " : "") + (String)(this.accountReference != null ? "accountReference=" + this.accountReference + ", " : "") + (String)(this.processTimestamp != null ? "processTimestamp=" + this.processTimestamp + ", " : "") + (String)(this.currencyCode != null ? "currencyCode=" + this.currencyCode + ", " : "") + (String)(this.amount != null ? "amount=" + this.amount + ", " : "") + (String)(this.comments != null ? "comments=" + this.comments : "") + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Balance balance = (Balance)o;
        if (this.trackingNumber != null ? !this.trackingNumber.equals(balance.trackingNumber) : balance.trackingNumber != null) {
            return false;
        }
        if (this.bankTrackingNumber != null ? !this.bankTrackingNumber.equals(balance.bankTrackingNumber) : balance.bankTrackingNumber != null) {
            return false;
        }
        if (this.accountReference != null ? !this.accountReference.equals(balance.accountReference) : balance.accountReference != null) {
            return false;
        }
        if (this.processTimestamp != null ? !this.processTimestamp.equals(balance.processTimestamp) : balance.processTimestamp != null) {
            return false;
        }
        if (this.currencyCode != null ? !this.currencyCode.equals(balance.currencyCode) : balance.currencyCode != null) {
            return false;
        }
        if (this.amount != null ? !this.amount.equals(balance.amount) : balance.amount != null) {
            return false;
        }
        return this.comments != null ? this.comments.equals(balance.comments) : balance.comments == null;
    }

    public int hashCode() {
        int result = this.trackingNumber != null ? this.trackingNumber.hashCode() : 0;
        result = 31 * result + (this.bankTrackingNumber != null ? this.bankTrackingNumber.hashCode() : 0);
        result = 31 * result + (this.accountReference != null ? this.accountReference.hashCode() : 0);
        result = 31 * result + (this.processTimestamp != null ? this.processTimestamp.hashCode() : 0);
        result = 31 * result + (this.currencyCode != null ? this.currencyCode.hashCode() : 0);
        result = 31 * result + (this.amount != null ? this.amount.hashCode() : 0);
        result = 31 * result + (this.comments != null ? this.comments.hashCode() : 0);
        return result;
    }
}

