package ar.com.sdd.banconnector.api.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;

@JsonIgnoreProperties(ignoreUnknown=true)
public class CollectionItemStatus implements Serializable {


    private BanconnectorEnum.StatusEnum status = BanconnectorEnum.StatusEnum.PENDING;
    private String statusDescription = null;

    public CollectionItemStatus() {

    }

    /**
     * Estado de la publicación de este documento
     **/




    @JsonProperty("status")
    @NotNull
    public BanconnectorEnum.StatusEnum getStatus() {
        return status;
    }

    public void setStatus(BanconnectorEnum.StatusEnum status) {
        this.status = status;
    }

    /**
     * Descripción más detallada del estado de ser necesaria
     **/


    @JsonProperty("statusDescription")
    @Size(max = 1000)
    public String getStatusDescription() {
        return statusDescription;
    }

    public void setStatusDescription(String statusDescription) {
        this.statusDescription = statusDescription;
    }

    @Override
    public String toString() {
        return "CollectionItemStatus ["
                + ((status != null) ? "status=" + status + ", " : "")
                + ((statusDescription != null) ? "statusDescription=" + statusDescription : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        CollectionItemStatus that = (CollectionItemStatus) o;

        if (status != that.status) return false;
        return statusDescription != null ? statusDescription.equals(that.statusDescription) : that.statusDescription == null;
    }

    @Override
    public int hashCode() {
        int result = status != null ? status.hashCode() : 0;
        result = 31 * result + (statusDescription != null ? statusDescription.hashCode() : 0);
        return result;
    }
}

