package ar.com.sdd.banconnector.api.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;

@JsonIgnoreProperties(ignoreUnknown=true)
public class LoadTestItem implements Serializable {

    private Integer id = null;
    private String value = null;

    public LoadTestItem() {

    }

    /**
     * Id del item
     **/


    @JsonProperty("id")
    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    /**
     * Campo de datos aleatorios con máximo de bytes dictado por el parametro itemSize
     **/


    @JsonProperty("value")
    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }


    @Override
    public String toString() {
        return "LoadTestItem ["
                + ((id != null) ? "id=" + id + ", " : "")
                + ((value != null) ? "value=" + value : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        LoadTestItem item = (LoadTestItem) o;

        if (id != null ? !id.equals(item.id) : item.id != null) return false;
        return value != null ? value.equals(item.value) : item.value == null;
    }

    @Override
    public int hashCode() {
        int result = id != null ? id.hashCode() : 0;
        result = 31 * result + (value != null ? value.hashCode() : 0);
        return result;
    }
}

